package com.biz.crm.mdm.business.region.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 行政区域层级
 *
 * @author sunx
 * @date 2022/5/16
 */
@AllArgsConstructor
@Getter
public enum RegionLevelEnum {
  /** 行政区域层级 */
  ZERO("0", "0", "国家级", "0"),
  ONE("1", "1", "省", "1"),
  TWO("2", "2", "市", "2"),
  THREE("3", "3", "区", "3"),
  FOUR("4", "4", "街道", "4"),
  FIVE("5", "5", "社区", "5"),
  ;
  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;
}
