package com.biz.crm.mdm.business.region.sdk.service;

import java.util.List;
import java.util.Map;

/**
 * 行政区域接口
 *
 * @author sunx
 * @date 2021/10/8
 */
public interface RegionVoService {

  /**
   * 获取regionCode对应的regionName的map
   *
   * <p>key->regionCode,value->regionName
   *
   * @param regionCodeList
   * @return
   */
  Map<String, String> findRegionCodeNameMap(List<String> regionCodeList);

  /**
   * 获取regionName对应的regionCode
   *
   * @param regionName
   * @param parentCode
   * @return
   */
  String findRegionCode(String regionName, String parentCode);
}
