package com.biz.crm.mdm.business.region.sdk.dto;

import io.swagger.annotations.ApiModelProperty;

/**
 * @author Kevin
 * @title TreeDto
 * @date 2023/3/10 11:29
 * @description
 */
public class TreeDto {
  @ApiModelProperty("id")
  private String id;

  @ApiModelProperty("租户")
  private String tenantCode;

  @ApiModelProperty("本节点code")
  private String code;

  @ApiModelProperty("名称")
  private String name;

  @ApiModelProperty("排除这个编码及全部下级")
  private String excludeCodeAndChildren;

  @ApiModelProperty("只查询这个编码及全部下级")
  private String includeCodeAndChildren;

  @ApiModelProperty("启用状态 传009只查启用，不传查询全部")
  private String enableStatus;

  @ApiModelProperty("默认值009")
  private String delFlag;

  @ApiModelProperty("父节点code")
  private String parentCode;

  @ApiModelProperty("规则code查询用")
  private String ruleCode;

  @ApiModelProperty("层级等级查询用")
  private Integer levelNum;

  @ApiModelProperty("禁用标记")
  private boolean disable;

  public TreeDto() {}

  public TreeDto(
      String id,
      String tenantCode,
      String code,
      String name,
      String excludeCodeAndChildren,
      String includeCodeAndChildren,
      String enableStatus,
      String delFlag,
      String parentCode,
      String ruleCode,
      Integer levelNum,
      boolean disable) {
    this.id = id;
    this.tenantCode = tenantCode;
    this.code = code;
    this.name = name;
    this.excludeCodeAndChildren = excludeCodeAndChildren;
    this.includeCodeAndChildren = includeCodeAndChildren;
    this.enableStatus = enableStatus;
    this.delFlag = delFlag;
    this.parentCode = parentCode;
    this.ruleCode = ruleCode;
    this.levelNum = levelNum;
    this.disable = disable;
  }

  @Override
  public String toString() {
    return "TreeDto{"
        + "id='"
        + id
        + '\''
        + ", tenantCode='"
        + tenantCode
        + '\''
        + ", code='"
        + code
        + '\''
        + ", name='"
        + name
        + '\''
        + ", excludeCodeAndChildren='"
        + excludeCodeAndChildren
        + '\''
        + ", includeCodeAndChildren='"
        + includeCodeAndChildren
        + '\''
        + ", enableStatus='"
        + enableStatus
        + '\''
        + ", delFlag='"
        + delFlag
        + '\''
        + ", parentCode='"
        + parentCode
        + '\''
        + ", ruleCode='"
        + ruleCode
        + '\''
        + ", levelNum="
        + levelNum
        + ", disable="
        + disable
        + '}';
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getExcludeCodeAndChildren() {
    return excludeCodeAndChildren;
  }

  public void setExcludeCodeAndChildren(String excludeCodeAndChildren) {
    this.excludeCodeAndChildren = excludeCodeAndChildren;
  }

  public String getIncludeCodeAndChildren() {
    return includeCodeAndChildren;
  }

  public void setIncludeCodeAndChildren(String includeCodeAndChildren) {
    this.includeCodeAndChildren = includeCodeAndChildren;
  }

  public String getEnableStatus() {
    return enableStatus;
  }

  public void setEnableStatus(String enableStatus) {
    this.enableStatus = enableStatus;
  }

  public String getDelFlag() {
    return delFlag;
  }

  public void setDelFlag(String delFlag) {
    this.delFlag = delFlag;
  }

  public String getParentCode() {
    return parentCode;
  }

  public void setParentCode(String parentCode) {
    this.parentCode = parentCode;
  }

  public String getRuleCode() {
    return ruleCode;
  }

  public void setRuleCode(String ruleCode) {
    this.ruleCode = ruleCode;
  }

  public Integer getLevelNum() {
    return levelNum;
  }

  public void setLevelNum(Integer levelNum) {
    this.levelNum = levelNum;
  }

  public boolean getDisable() {
    return disable;
  }

  public void setDisable(boolean disable) {
    this.disable = disable;
  }
}
