package com.biz.crm.mdm.business.region.sdk.event;

import com.biz.crm.mdm.business.region.sdk.vo.RegionSaleTerritoryVo;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;
import java.util.List;

/**
 * @author hejun
 * @title RegionSaleTerritoryEventListener
 * @date 2023/3/1 9:29
 * @description 行政区域调用销售区域数据的事件监听接口
 */
public interface RegionSaleTerritoryEventListener extends NebulaEvent {

  /**
   * 根据行政区域编码集合查询对应得销售区域关联数据
   *
   * @param regionCodes
   * @return
   */
  List<RegionSaleTerritoryVo> findSaleTerritoryCodeByRegionCodes(List<String> regionCodes);
}
