package com.biz.crm.mdm.business.region.sdk.service;

import com.biz.crm.business.common.sdk.vo.TreeVo;
import com.biz.crm.mdm.business.region.sdk.vo.RegionVo;

import java.util.List;
import java.util.Map;

/**
 * 行政区域接口
 *
 * @author sunx
 * @date 2021/10/8
 */
public interface RegionVoService {

  /**
   * 获取regionCode对应的regionName的map
   *
   * <p>key->regionCode,value->regionName
   *
   * @param regionCodeList
   * @return
   */
  Map<String, String> findRegionCodeNameMap(List<String> regionCodeList);

  /**
   * 获取regionName对应的regionCode
   *
   * @param regionName
   * @param parentCode
   * @return
   */
  String findRegionCode(String regionName, String parentCode);

  /**
   * 根据行政区域编码查询行政区域信息
   * @param regionCode
   * @return
   */
  RegionVo findByRegionCode(String regionCode);

  /**
   * 根据父级编码查询
   * @param parentCode 父级编码
   * @return
   */
  List<RegionVo> findByParentCode(String parentCode);

  /**
   *
   * 根据行政区域编码查询构建组织树
   *
   * @param regionCode 行政区域编码
   * @param items 过滤条件
   * @return
   */
  List<TreeVo> findRegionTreeByRegionCode(String regionCode,List<String>items);
}
