package com.biz.crm.mdm.business.region.sdk.utils;

import com.biz.crm.mdm.business.region.sdk.vo.LazyTreeVo;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author hejun
 * @title TreeUtil
 * @date 2023/2/27 22:22
 * @description 自定义树构建
 */
public class TreeUtil {

  /**
   * 构建懒加载树形结构
   *
   * @param totalList
   * @return
   */
  public static List<LazyTreeVo> generateLazyTreeByParentCode(List<LazyTreeVo> totalList) {
    //构建树list
    List<LazyTreeVo> treeList = new ArrayList<>();
    //当前操作层级数据
    List<LazyTreeVo> curLevelList = new ArrayList<>();
    //未操作数据
    List<LazyTreeVo> restList = new ArrayList<>();
    //key:id
    Map<String, LazyTreeVo> totalMap = totalList.stream().collect(Collectors.toMap(LazyTreeVo::getCode, v -> v));
    //查找第一层
    for (LazyTreeVo item :
        totalList) {
      if (!StringUtils.isNotEmpty(item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
        treeList.add(item);
        curLevelList.add(item);
      } else {
        restList.add(item);
      }
    }
    //构建数据，从第二层开始
    while (curLevelList.size() > 0 && restList.size() > 0) {
      List<LazyTreeVo> restTempList = new ArrayList<>();
      List<LazyTreeVo> curLevelTempList = new ArrayList<>();
      Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(LazyTreeVo::getCode, LazyTreeVo::getCode, (v1, v2) -> v1));
      Map<String, List<LazyTreeVo>> curLevelChildrenMap = new HashMap<>();
      for (LazyTreeVo item :
          restList) {
        if (curLevelMap.containsKey(item.getParentCode())) {
          curLevelTempList.add(item);

          List<LazyTreeVo> childrenList = new ArrayList<>();
          if (curLevelChildrenMap.containsKey(item.getParentCode())) {
            childrenList.addAll(curLevelChildrenMap.get(item.getParentCode()));
          }
          childrenList.add(item);
          curLevelChildrenMap.put(item.getParentCode(), childrenList);
        } else {
          restTempList.add(item);
        }
      }
      for (LazyTreeVo item : curLevelList) {
        if (curLevelChildrenMap.containsKey(item.getCode())) {
          item.setChildren(curLevelChildrenMap.get(item.getCode()));
        }
      }
      curLevelList.clear();
      curLevelList.addAll(curLevelTempList);
      restList.clear();
      restList.addAll(restTempList);
    }
    return treeList;
  }
}
