package com.biz.crm.mdm.business.sales.org.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.sales.org.feign.feign.interna.SalesOrgSubComOrgFeignImpl;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 销售组织基本信息feign
 *
 * @author sunx
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = SalesOrgSubComOrgFeignImpl.class)
public interface SalesOrgSubComOrgFeign {

    /**
     * 根据分子公司组织编码（客户编码）查询对应关系
     *
     * @param subComOrgCodeList
     * @return java.util.List<com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo>
     * @author huojia
     * @date 2022/11/22 14:36
     **/
    @PostMapping("/v1/salesOrg/salesOrgSubComOrg/listBySubComOrgCodeList")
    Result<List<SalesOrgSubComOrgVo>> listBySubComOrgCodeList(@RequestBody List<String> subComOrgCodeList);

    @GetMapping("/v1/salesOrg/salesOrgSubComOrg/findBySaleOrgErpCode")
    Result<List<SalesOrgSubComOrgVo>> findBySaleOrgErpCode(@RequestParam("salesOrgErpCode") String salesOrgErpCode);

    @GetMapping("/v1/salesOrg/salesOrgSubComOrg/findAll")
    Result<List<SalesOrgSubComOrgVo>> findAll();
}