package com.biz.crm.mdm.business.sales.org.feign.feign;

import java.util.List;
import java.util.Map;
import java.util.Set;

import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.sales.org.feign.feign.interna.SalesOrgVoFeignImpl;
import com.biz.crm.mdm.business.sales.org.sdk.dto.RelateSalesOrgCodeQueryDto;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgQueryDto;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;

/**
 * 销售组织基本信息feign
 *
 * @author sunx
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = SalesOrgVoFeignImpl.class)
public interface SalesOrgVoFeign {

    /**
     * 根据销售组织编码查询全部上级（含当前）销售组织列表
     *
     * @param orgCode
     * @return
     */
    @GetMapping("/v1/salesOrg/salesOrg/findAllParentBySalesOrgCode")
    Result<List<SalesOrgVo>> findAllParentBySalesOrgCode(@RequestParam("salesOrgCode") String orgCode);

    /**
     * 按orgCode集合查询
     *
     * @param salesOrgCode
     * @return
     */
    @GetMapping(value = {"/v1/salesOrg/salesOrg/findBySalesOrgCode"})
    Result<SalesOrgVo> findBySalesOrgCode(@RequestParam("salesOrgCode") String salesOrgCode);

    /**
     * 按orgCode集合查询
     *
     * @param orgCodeList
     * @return
     */
    @GetMapping(value = {"/v1/salesOrg/salesOrg/findBySalesOrgCodes"})
    Result<List<SalesOrgVo>> findBySalesOrgCodes(@RequestParam("salesOrgCodeList") List<String> orgCodeList);

    /**
     * 根据销售组织编码集合查询全部上级（含当前）销售组织列表
     *
     * @param orgCodes
     * @return
     */
    @GetMapping(value = {"/v1/salesOrg/salesOrg/findAllParentBySalesOrgCodes"})
    Result<List<SalesOrgVo>> findAllParentBySalesOrgCodes(@RequestParam("salesOrgCodes") List<String> orgCodes);

    /**
     * 查询指定orgCode下的所有子节点
     *
     * @param orgCode
     * @return
     */
    @GetMapping(value = {"/v1/salesOrg/salesOrg/findAllChildrenBySalesOrgCode"})
    Result<List<SalesOrgVo>> findAllChildrenBySalesOrgCode(@RequestParam("salesOrgCode") String orgCode);

    /**
     * 查询orgCodes下的所有子节点
     *
     * @param orgCodes
     * @return
     */
    @GetMapping(value = {"/v1/salesOrg/salesOrg/findAllChildrenVoBySalesOrgCodes"})
    Result<List<SalesOrgVo>> findAllChildrenBySalesOrgCodes(@RequestParam("salesOrgCodes") List<String> orgCodes);

    /**
     * 获取销售组织编码
     *
     * @param dto
     * @return
     */
    @GetMapping(value = {"/v1/salesOrg/salesOrg/findBySalesOrgQueryDto"})
    Result<Set<String>> findBySalesOrgQueryDto(@SpringQueryMap SalesOrgQueryDto dto);

    /**
     * 根据获取销售组织对应的未删除的上级或下级编码
     *
     * @param dto
     * @return
     */
    @GetMapping(value = {"/v1/salesOrg/salesOrg/findByRelateSalesOrgCodeQueryDto"})
    Result<Map<String, String>> findByRelateSalesOrgCodeQueryDto(@SpringQueryMap RelateSalesOrgCodeQueryDto dto);

    /**
     * 查询指定组织层级 下的所有销售组织编码和名称
     * @param salesOrgLevel
     * @return
     */
    @GetMapping(value = {"/v1/salesOrg/salesOrg/findAllSalesOrgLevelBySalesOrg"})
    Result<List<SalesOrgVo>> findAllSalesOrgLevelBySalesOrg(@RequestParam("salesOrgLevel") String salesOrgLevel);

    /**
     * 根据销售组织erp编码获取销售组织
     * @param salesOrgErpCodeList 销售组织erp编码列表
     * @author jiangyin
     * @date 2023/1/16 14:25
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List<com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo>>
     */
    @PostMapping(value = {"/v1/salesOrg/salesOrg/findByErpCodeList"})
    Result<List<SalesOrgVo>> findByErpCodeList(@RequestBody List<String> salesOrgErpCodeList);

    /**
     * 根据erp编码查询销售组织全部信息
     *
     * @param erpCodes erp编码列表
     * @return Map<String, SalesOrgVo>
     */
    @ApiOperation("根据erp编码查询销售组织全部信息")
    @PostMapping(value = {"/v1/salesOrg/salesOrg/getSalesMapByErpCodes"})
    Result<Map<String, SalesOrgVo>> getSalesMapByErpCodes(@RequestBody List<List<String>> erpCodes);

    /**
     * 根据tpm编码查询销售组织全部信息
     *
     * @param tpmCodes tpm编码列表
     * @return Map<String, SalesOrgVo>
     */
    @ApiOperation("根据tpm编码查询销售组织全部信息")
    @PostMapping(value = {"/v1/salesOrg/salesOrg/getSalesMapByTpmCodes"})
    Result<Map<String, SalesOrgVo>> getSalesMapByTpmCodes(@RequestBody List<String> tpmCodes);


    @ApiOperation("根据销售组织编码集合查询对应sap编码")
    @PostMapping(value = {"/v1/salesOrg/salesOrg/findSapCodesBySalesOrgCodes"})
    Result<Map<String, String>> findSapCodesBySalesOrgCodes(List<String> salesOrgCodes);

    /**
     * 根据销售组织编码集合查询对应名称
     *
     * @param salesOrgCodes 销售组织编码集合
     * @return Map<String, String>
     */
    @ApiOperation("根据销售组织编码集合查询对应名称")
    @PostMapping(value = {"/v1/salesOrg/salesOrg/findNameBySalesOrgCodes"})
    Result<Map<String, String>> findNameBySalesOrgCodes(@RequestBody List<List<String>> salesOrgCodes);

    /**
     * 根据销售组织编码集合查询
     *
     * @param salesOrgCodes 销售组织编码集合
     * @return Result<List<SalesOrgVo>>
     */
    @ApiOperation("根据销售组织编码集合查询")
    @PostMapping(value = {"/v1/salesOrg/salesOrg/findBySalesOrgCodesPost"})
    Result<List<SalesOrgVo>> findBySalesOrgCodesPost(@RequestBody List<String> salesOrgCodes);
}