package com.biz.crm.mdm.business.sales.org.feign.feign.interna;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.sales.org.feign.feign.SalesOrgSubComOrgFeign;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @program: 组织行基本信息feign熔断实现
 * @description:
 * @author: Bao Hongbin
 * @create: 2021-11-24 11:22
 */
@Component
public class SalesOrgSubComOrgFeignImpl implements FallbackFactory<SalesOrgSubComOrgFeign> {

    @Override
    public SalesOrgSubComOrgFeign create(Throwable throwable) {

        return new SalesOrgSubComOrgFeign() {
            @Override
            public Result<List<SalesOrgSubComOrgVo>> listBySubComOrgCodeList(List<String> subComOrgCodeList) {
                throw new UnsupportedOperationException("根据分子公司组织编码（客户编码）查询对应关系熔断");
            }

            @Override
            public Result<List<SalesOrgSubComOrgVo>> findBySaleOrgErpCode(String salesOrgErpCode) {
                throw new UnsupportedOperationException("根据销售组织erp编码查询对应关系熔断");
            }

            @Override
            public Result<List<SalesOrgSubComOrgVo>> findAll() {
                throw new UnsupportedOperationException("获取全部分子公司客户关联销售组织熔断");
            }
        };
    }
}
