package com.biz.crm.mdm.business.sales.org.feign.feign.interna;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.sales.org.sdk.dto.RelateSalesOrgCodeQueryDto;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgQueryDto;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.sales.org.feign.feign.SalesOrgVoFeign;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @program: 组织行基本信息feign熔断实现
 * @description:
 * @author: Bao Hongbin
 * @create: 2021-11-24 11:22
 */
@Component
public class SalesOrgVoFeignImpl implements FallbackFactory<SalesOrgVoFeign> {

  @Override
  public SalesOrgVoFeign create(Throwable throwable) {
    return new SalesOrgVoFeign() {

      @Override
      public Result<List<SalesOrgVo>> findAllParentBySalesOrgCode(String orgCode) {
        throw new UnsupportedOperationException("根据组织编码查询全部上级（含当前）组织列表熔断");
      }

      @Override
      public Result<SalesOrgVo> findBySalesOrgCode(String salesOrgCode) {
        throw new UnsupportedOperationException("按orgCode查询熔断");
      }

      @Override
      public Result<List<SalesOrgVo>> findBySalesOrgCodes(List<String> orgCodeList) {
        throw new UnsupportedOperationException("按orgCode集合查询熔断");
      }

      @Override
      public Result<List<SalesOrgVo>> findAllParentBySalesOrgCodes(List<String> orgCodes) {
        throw new UnsupportedOperationException("根据组织编码集合查询全部上级（含当前）组织列表熔断");
      }

      @Override
      public Result<List<SalesOrgVo>> findAllChildrenBySalesOrgCode(String orgCode) {
        throw new UnsupportedOperationException("根据组织编码查询下级组织列表熔断");
      }

      /**
       * 查询orgCodes下的所有子节点
       *
       * @param orgCodes
       * @return
       */
      @Override
      public Result<List<SalesOrgVo>> findAllChildrenBySalesOrgCodes(List<String> orgCodes) {
        throw new UnsupportedOperationException("根据组织编码列表查询下级组织列表熔断");
      }

      @Override
      public Result<Set<String>> findBySalesOrgQueryDto(SalesOrgQueryDto dto) {
        throw new UnsupportedOperationException("获取组织编码熔断");
      }

      @Override
      public Result<Map<String,String>> findByRelateSalesOrgCodeQueryDto(RelateSalesOrgCodeQueryDto dto) {
        throw new UnsupportedOperationException("根据获取组织对应的未删除的上级或下级编码熔断");
      }

      @Override
      public Result<List<SalesOrgVo>> findAllSalesOrgLevelBySalesOrg(String salesOrgLevel) {
        throw new UnsupportedOperationException("根据获取组织层级对应的下的所有销售组织编码和名称熔断");
      }

      @Override
      public Result<List<SalesOrgVo>> findByErpCodeList(List<String> salesOrgErpCodeList) {
        throw new UnsupportedOperationException("根据销售组织erp编码获取销售组织熔断");
      }

      @Override
      public Result<Map<String, SalesOrgVo>> getSalesMapByErpCodes(List<List<String>> erpCodes) {
        throw new UnsupportedOperationException("根据erp编码查询销售组织全部信息熔断");
      }

      @Override
      public Result<Map<String, SalesOrgVo>> getSalesMapByTpmCodes(List<String> tpmCodes) {
        throw new UnsupportedOperationException("根据tpm编码查询销售组织全部信息熔断");
      }

      @Override
      public Result<Map<String, String>> findSapCodesBySalesOrgCodes(List<String> salesOrgCodes) {
        throw new UnsupportedOperationException("根据销售组织编码集合查询对应sap编码信息熔断");
      }

      @Override
      public Result<Map<String, String>> findNameBySalesOrgCodes(List<List<String>> salesOrgCodes) {
        throw new UnsupportedOperationException("根据销售组织编码集合查询对应名称信息熔断");
      }

      @Override
      public Result<List<SalesOrgVo>> findBySalesOrgCodesPost(List<String> orgCodes) {
        throw new UnsupportedOperationException("根据销售组织编码集合查询销售组织信息熔断");
      }
    };
  }
}
