package com.biz.crm.mdm.business.sales.org.feign.service.interna;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.sales.org.feign.feign.SalesOrgVoFeign;
import com.biz.crm.mdm.business.sales.org.sdk.dto.RelateSalesOrgCodeQueryDto;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgPaginationDto;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgQueryDto;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.*;

/**
 * 组织基本信息sdk实现
 */
@Service
public class SalesOrgVoServiceImpl implements SalesOrgVoService {

    @Autowired(required = false)
    private SalesOrgVoFeign salesOrgVoFeign;

    @Override
    public Page<SalesOrgVo> findByConditions(Pageable pageable, SalesOrgPaginationDto paginationDto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SalesOrgVo findDetailsById(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SalesOrgVo findBySalesOrgCode(String orgCode) {
        if (StringUtils.isEmpty(orgCode)) {
            return null;
        }
        return this.salesOrgVoFeign.findBySalesOrgCode(orgCode).getResult();
    }

    @Override
    public List<SalesOrgVo> findDetailsByIds(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SalesOrgVo> findBySalesOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return Collections.emptyList();
        }
        return this.salesOrgVoFeign.findBySalesOrgCodes(orgCodes).getResult();
    }

    @Override
    public List<SalesOrgVo> findBySalesOrgCodesPost(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return Collections.emptyList();
        }
        return this.salesOrgVoFeign.findBySalesOrgCodesPost(orgCodes).getResult();
    }

    @Override
    public List<SalesOrgVo> findAllChildrenById(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SalesOrgVo> findAllChildrenBySalesOrgCode(String orgCode) {
        if (!StringUtils.isNotBlank(orgCode)) {
            return null;
        }
        return salesOrgVoFeign.findAllChildrenBySalesOrgCode(orgCode).getResult();
    }

    @Override
    public List<SalesOrgVo> findAllChildrenBySalesOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return Collections.emptyList();
        }
        return this.salesOrgVoFeign.findAllChildrenBySalesOrgCodes(orgCodes).getResult();
    }

    /**
     * 通过企业组织编码查询其所有上级及其本身
     *
     * @param orgCode 企业组织编码
     * @return List<SalesOrgVo> 其所有上级及其本身集合
     */
    @Override
    public List<SalesOrgVo> findAllParentBySalesOrgCode(String orgCode) {
        if (!StringUtils.isNotBlank(orgCode)) {
            return null;
        }
        return salesOrgVoFeign.findAllParentBySalesOrgCode(orgCode).getResult();
    }

    /**
     * 根据 组织编码集合查询 全部上级（含当前）组织列表
     *
     * @param orgCodes
     * @return
     */
    @Override
    public List<SalesOrgVo> findAllParentBySalesOrgCodes(List<String> orgCodes) {
        if (CollectionUtils.isEmpty(orgCodes)) {
            return null;
        }
        return salesOrgVoFeign.findAllParentBySalesOrgCodes(orgCodes).getResult();
    }

    @Override
    public Set<String> findBySalesOrgQueryDto(SalesOrgQueryDto dto) {
        return salesOrgVoFeign.findBySalesOrgQueryDto(dto).getResult();
    }

    @Override
    public Map<String, String> findByRelateSalesOrgCodeQueryDto(RelateSalesOrgCodeQueryDto dto) {
        return salesOrgVoFeign.findByRelateSalesOrgCodeQueryDto(dto).getResult();
    }

    /**
     * 查询指定salesOrgLevel 下的所有销售组织编码和名称
     *
     * @param salesOrgLevel
     * @return
     */
    @Override
    public List<SalesOrgVo> findAllSalesOrgLevelBySalesOrg(String salesOrgLevel) {
        return salesOrgVoFeign.findAllSalesOrgLevelBySalesOrg(salesOrgLevel).getResult();
    }

    @Override
    public List<String> findBySalesOrgName(String salesAgencyCode) {
        return null;
    }


    @Override
    public List<SalesOrgVo> findByErpCodeList(List<String> salesOrgErpCodeList) {
        return salesOrgVoFeign.findByErpCodeList(salesOrgErpCodeList).getResult();
    }

    /**
     * 根据销售编码查询销售名称
     * @param source2Code
     * @return
     */
    @Override
    public List<String> findByMdgSalesOrgCode(String source2Code) {
        return null;
    }

    /**
     * 根据erp编码查询销售组织全部信息
     *
     * @param erpCodes erp编码列表
     * @return Map<String, SalesOrgVo>
     */
    @Override
    public Map<String, SalesOrgVo> getSalesMapByErpCodes(List<List<String>> erpCodes) {
        Result<Map<String, SalesOrgVo>> result = this.salesOrgVoFeign.getSalesMapByErpCodes(erpCodes);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 根据tpm编码查询销售组织全部信息
     *
     * @param tpmCodes tpm编码列表
     * @return Map<String, SalesOrgVo>
     */
    @Override
    public Map<String, SalesOrgVo> getSalesMapByTpmCodes(List<String> tpmCodes) {
        Result<Map<String, SalesOrgVo>> result = this.salesOrgVoFeign.getSalesMapByTpmCodes(tpmCodes);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     *  更据销售组织编码集合查询对应sap编码
     * @param salesOrgCodes 销售组织编码
     * @return
     */
    @Override
    public Map<String, String> findSapCodesBySalesOrgCodes(List<String> salesOrgCodes) {
        Result<Map<String, String>> result = this.salesOrgVoFeign.findSapCodesBySalesOrgCodes(salesOrgCodes);
        return result.getResult();
    }

    @Override
    public Map<String, String> findNameBySalesOrgCodes(List<List<String>> salesOrgCodes) {
        Result<Map<String, String>> result = this.salesOrgVoFeign.findNameBySalesOrgCodes(salesOrgCodes);
        return result.getResult();
    }


}
