package com.biz.crm.mdm.business.sales.org.local.authority;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeGroupRegister;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * @describe: 按销售组织维度进行授权的选项分组
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.10.28 14:39
 */
@Component("salesOrgSelectAuthorityModeGroupRegister")
public class SalesOrgAuthorityModeGroupRegister implements SelectAuthorityModeGroupRegister {
    @Override
    public String groupCode() {
        return "sales_org_group";
    }

    @Override
    public String groupName() {
        return "按照销售组织维度授权";
    }

    @Override
    public Set<String> viewFieldNames() {
        return Sets.newHashSet("salesOrgCodes", "salesOrgCode", "sales_org_code","sales_org_province_code");
    }

    @Override
    public Set<String> repositoryFieldNames() {
        return Sets.newHashSet("sales_org_codes", "sales_org_code","sales_org_province_code");
    }
}
