package com.biz.crm.mdm.business.sales.org.local.authority;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 匹配当前登录者/操作者所属销售组织
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.13 20:14
 */
@Component("salesOrgAuthorityModeRegister")
public class SalesOrgAuthorityModeRegister implements SelectAuthorityModeRegister {

    @Autowired(required = false)
    private OrgVoService orgVoService;
    @Override
    public String modeKey() {
        return "salesOrgAuthorityModeRegister";
    }

    @Override
    public String modeName() {
        return "按照当前登录者/操作者所属销售组织进行销售组织维度的值确认";
    }

    @Override
    public String controlKey() {
        return "salesOrgAuthorityModeRegister";
    }

    @Override
    public int sort() {
        return 8;
    }

    @Override
    public String groupCode() {
        return "sales_org_group";
    }

    @Override
    public String converterKey() {
        return "chartEqualMarsAuthorityValueAstConverter";
    }

    @Override
    public boolean isArrayValue() {
        return false;
    }

    @Override
    public boolean isStaticValue() {
        return false;
    }

    @Override
    public Class<?> modeValueClass() {
        return String.class;
    }

    @Override
    public Object staticValue(String[] staticValues) {
        return null;
    }

    @Override
    public Object dynamicValue(UserIdentity loginDetails, String modeGroupCode) {
        String identityType = loginDetails.getIdentityType();
        //如果不是后台管理用户，就不销售组织位字段进行权限控制
        if (!StringUtils.equals(identityType, "u")) {
            return null;
        }
        AbstractCrmUserIdentity loginUserDetails = (AbstractCrmUserIdentity) loginDetails;
        //如果没有当前字段，就不进行权限控制
        if (!loginUserDetails.hasField("orgCode")) {
            return null;
        }
        Object orgCodeObject = loginUserDetails.invokeFieldValue("orgCode");
        if (orgCodeObject == null) {
            return null;
        }
        //根据orgCode查找销售组织
        OrgVo orgVo = orgVoService.findByOrgCode(orgCodeObject.toString());
        if (null == orgVo || StringUtils.isBlank(orgVo.getSalesOrgCode())) {
            return null;
        }

        return orgVo.getSalesOrgCode();
    }
}
