package com.biz.crm.mdm.business.sales.org.local.authority;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/12/28 9:42
 * @description: 所有销售组织
 */
@Component("salesOrgAuthorityModeRegisterForAll")
public class SalesOrgAuthorityModeRegisterForAll implements SelectAuthorityModeRegister {
    @Override
    public String modeKey() {
        return "salesOrgAuthorityModeRegisterForAll";
    }

    @Override
    public String modeName() {
        return "按照所有销售组织维度的值确认";
    }

    @Override
    public String controlKey() {
        return "salesOrgAuthorityModeRegisterForAll";
    }

    @Override
    public int sort() {
        return 10;
    }

    @Override
    public String groupCode() {
        return "sales_org_group";
    }

    @Override
    public String converterKey() {
        return "chartEqualMarsAuthorityValueAstConverter";
    }

    @Override
    public boolean isArrayValue() {
        return false;
    }

    @Override
    public boolean isStaticValue() {
        return false;
    }

    @Override
    public Class<?> modeValueClass() {
        return String.class;
    }

    @Override
    public Object staticValue(String[] staticValues) {
        return null;
    }

    @Override
    public Object dynamicValue(UserIdentity loginDetails, String modeGroupCode) {
        String identityType = loginDetails.getIdentityType();
        //如果不是后台管理用户，就不销售组织位字段进行权限控制
        if (!StringUtils.equals(identityType, "u")) {
            return null;
        }
        //查所有就直接返回空
        return null;
    }
}
