package com.biz.crm.mdm.business.sales.org.local.authority;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/12/28 9:42
 * @description: 固定销售组织
 */
@Component("salesOrgAuthorityModeRegisterForSelect")
public class SalesOrgAuthorityModeRegisterForSelect implements SelectAuthorityModeRegister {
    @Override
    public String modeKey() {
        return "salesOrgAuthorityModeRegisterForSelect";
    }

    @Override
    public String modeName() {
        return "按照固定销售组织维度的值确认";
    }

    @Override
    public String controlKey() {
        return "salesOrgAuthorityModeRegisterForSelect_select";
    }

    @Override
    public int sort() {
        return 12;
    }

    @Override
    public String groupCode() {
        return "sales_org_group";
    }

    @Override
    public String converterKey() {
        return "chartArrayMarsAuthorityAstConverter";
    }

    @Override
    public boolean isArrayValue() {
        return true;
    }

    @Override
    public boolean isStaticValue() {
        return true;
    }

    @Override
    public Class<?> modeValueClass() {
        return String.class;
    }

    @Override
    public Object staticValue(String[] staticValues) {
        return staticValues;
    }

    @Override
    public Object dynamicValue(UserIdentity loginDetails, String modeGroupCode) {
        return null;
    }
}
