package com.biz.crm.mdm.business.sales.org.local.authority;

import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.sales.org.local.entity.SalesOrg;
import com.biz.crm.mdm.business.sales.org.local.service.SalesOrgService;
import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2022/12/28 9:42
 * @description: 固定销售组织及其下级销售组织
 */
@Component("salesOrgAuthorityModeRegisterForSelectDown")
public class SalesOrgAuthorityModeRegisterForSelectDown implements SelectAuthorityModeRegister {
    @Autowired(required = false)
    private ApplicationContext applicationContext;

    @Override
    public String modeKey() {
        return "salesOrgAuthorityModeRegisterForSelectDown";
    }

    @Override
    public String modeName() {
        return "按照固定销售组织及其下级销售组织维度的值确认";
    }

    @Override
    public String controlKey() {
        return "salesOrgAuthorityModeRegisterForSelectDown_select";
    }

    @Override
    public int sort() {
        return 12;
    }

    @Override
    public String groupCode() {
        return "sales_org_group";
    }

    @Override
    public String converterKey() {
        return "chartArrayMarsAuthorityAstConverter";
    }

    @Override
    public boolean isArrayValue() {
        return true;
    }

    @Override
    public boolean isStaticValue() {
        return true;
    }

    @Override
    public Class<?> modeValueClass() {
        return String.class;
    }

    @Override
    public Object staticValue(String[] staticValues) {
        if(null == staticValues || staticValues.length == 0){
            return null;
        }
        SalesOrgService orgService = applicationContext.getBean(SalesOrgService.class);
        List<String> orgCodes = Lists.newArrayList(staticValues);
        List<SalesOrg> children = orgService.findAllChildrenBySalesOrgCodes(orgCodes);
        orgCodes.addAll(children.stream().map(SalesOrg::getSalesOrgCode).distinct().collect(Collectors.toList()));
        return orgCodes.stream().toArray(String[]::new);
    }

    @Override
    public Object dynamicValue(UserIdentity loginDetails, String modeGroupCode) {
        return null;
    }
}
