package com.biz.crm.mdm.business.sales.org.local.authority;

import com.biz.crm.mdm.business.sales.org.local.repository.SalesOrgRepository;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 销售组织 ruleCode规则编码取值
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023.1.11 13:39
 */
@Component("SalesOrgRuleCodeParameterValueBindingStrategy")
public class SalesOrgRuleCodeParameterValueBindingStrategy implements ParameterValueBindingStrategy {

    @Autowired
    private SalesOrgRepository salesOrgRepository;


    public SalesOrgRuleCodeParameterValueBindingStrategy() {
    }

    @Override
    public String getBindType() {
        return "Sales_Org_RuleCode";
    }

    @Override
    public String getBindTypeCnName() {
        return "销售组织ruleCode规则编码取值";
    }

    @Override
    public Boolean getOutside() {
        return false;
    }

    @Override
    public Class<?>[] matchedJavaClasses() {
        return new Class[]{CharSequence.class};
    }

    @Override
    public Object bindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
        String orgCode = (String) databaseExecuteExternalRequest.getAttribute("includeAllChildrenSalesOrgCode");
        if (StringUtils.isBlank(orgCode)) {
            return null;
        }
        String ruleCodeByOrgCode = salesOrgRepository.findRuleCodeByOrgCode(orgCode, TenantUtils.getTenantCode());
        if (StringUtils.isBlank(ruleCodeByOrgCode)) {
            return null;
        }
        return ruleCodeByOrgCode;
    }
}
