package com.biz.crm.mdm.business.sales.org.local.authority;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.bizunited.nebula.mars.sdk.register.SelectScopeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * 按照当前销售组织配置展示规则
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.13 20:15
 */
@Component("salesOrgScopeRegister")
public class SalesOrgScopeRegister implements SelectScopeRegister {

    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Override
    public String scopeKey() {
        return "sales_org_scope";
    }

    @Override
    public String selectName() {
        return "当前销售组织";
    }

    @Override
    public String controlKey() {
        return "sales_org_tree";
    }

    @Override
    public String controlName() {
        return "销售组织选择树";
    }

    /**
     * 判断是否启用该校验
     *
     * @param loginDetails
     * @param scopeValues
     * @return
     */
    @Override
    public boolean matched(UserIdentity loginDetails, String[] scopeValues) {
        if (scopeValues == null || scopeValues.length == 0) {
            return false;
        }
        String identityType = loginDetails.getIdentityType();
        // 如果不是后台管理用户，就不按职位进行权限控制
        if (!StringUtils.equals(identityType, "u")) {
            return false;
        }
        AbstractCrmUserIdentity loginUserDetails = (AbstractCrmUserIdentity) loginDetails;
        //如果没有当前字段，就不进行权限控制
        if (!loginUserDetails.hasField("orgCode")) {
            return false;
        }
        Object orgCodeObject = loginUserDetails.invokeFieldValue("orgCode");
        if (orgCodeObject == null) {
            return false;
        }
        //根据orgCode查找销售组织
        OrgVo orgVo = orgVoService.findByOrgCode(orgCodeObject.toString());
        if (null == orgVo || StringUtils.isBlank(orgVo.getSalesOrgCode())) {
            return false;
        }
        Set<String> scopeSet = new HashSet<>(Arrays.asList(scopeValues));
        return scopeSet.contains(orgVo.getSalesOrgCode());
    }
}
