package com.biz.crm.mdm.business.sales.org.local.authority;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sales.org.local.entity.SalesOrg;
import com.biz.crm.mdm.business.sales.org.local.service.SalesOrgService;
import com.bizunited.nebula.mars.sdk.register.SelectScopeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 按照当前及下级销售组织
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.13 20:19
 */
@Lazy
@Component("salesOrgTreeScopeRegister")
public class SalesOrgTreeScopeRegister implements SelectScopeRegister {
    @Autowired(required = false)
    private ApplicationContext applicationContext;
    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Override
    public String scopeKey() {
        return "sales_org_tree_scope";
    }

    @Override
    public String selectName() {
        return "当前及下级销售组织";
    }

    @Override
    public String controlKey() {
        return "sales_org_tree";
    }

    @Override
    public String controlName() {
        return "销售组织选择树";
    }

    @Override
    public boolean matched(UserIdentity loginDetails, String[] scopeValues) {
        SalesOrgService orgService = applicationContext.getBean(SalesOrgService.class);
        if (scopeValues == null || scopeValues.length == 0) {
            return false;
        }
        String identityType = loginDetails.getIdentityType();
        // 如果不是后台管理用户，就不按销售组织机构进行权限控制
        if (!StringUtils.equals(identityType, "u")) {
            return false;
        }
        AbstractCrmUserIdentity loginUserDetails = (AbstractCrmUserIdentity) loginDetails;
        //如果没有当前字段，就不进行权限控制
        if (!loginUserDetails.hasField("orgCode")) {
            return false;
        }
        Object orgCodeObject = loginUserDetails.invokeFieldValue("orgCode");
        if (orgCodeObject == null) {
            return false;
        }
        //根据orgCode查找销售组织
        OrgVo orgVo = orgVoService.findByOrgCode(orgCodeObject.toString());
        if (null == orgVo || StringUtils.isBlank(orgVo.getSalesOrgCode())) {
            return false;
        }

        // 如果当前登录人所属销售组织恰好是选择的销售组织
        List<String> orgCodes = Arrays.asList(scopeValues);
        if (orgCodes.contains(orgVo.getSalesOrgCode())) {
            return true;
        }
        // 校验当前登录人所属销售组织是否为选择销售组织的下级销售组织
        List<SalesOrg> children = orgService.findAllChildrenBySalesOrgCodes(orgCodes);
        if (CollectionUtils.isEmpty(children)) {
            return false;
        }
        Set<String> scopeSet = children.stream().map(SalesOrg::getSalesOrgCode).collect(Collectors.toSet());
        return scopeSet.contains(orgVo.getSalesOrgCode());
    }
}
