package com.biz.crm.mdm.business.sales.org.local.authority;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sales.org.local.entity.SalesOrg;
import com.biz.crm.mdm.business.sales.org.local.service.SalesOrgService;
import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: heguanyun
 * @Date: 2022/4/7 15:28 description:匹配当前登录者/操作者对应的hr组织的上级对应的所属销售组织及其下级销售组织
 */
@Component("salesOrgTreeUpAuthorityModeRegister")
@Lazy
public class SalesOrgTreeUpAuthorityModeRegister implements SelectAuthorityModeRegister {

    @Autowired(required = false)
    private ApplicationContext applicationContext;
    @Autowired(required = false)
    private OrgVoService orgVoService;

    @Override
    public String modeKey() {
        return "salesOrgTreeUpAuthorityModeRegister";
    }

    @Override
    public String modeName() {
        return "按照当前登录者/操作者对应的hr组织的上级对应的所属销售组织及其下级销售组织";
    }

    @Override
    public String controlKey() {
        return "salesOrgTreeUpAuthorityModeRegister";
    }

    @Override
    public String groupCode() {
        return "sales_org_group";
    }

    @Override
    public String converterKey() {
        return "chartArrayMarsAuthorityAstConverter";
    }

    @Override
    public int sort() {
        return 9;
    }

    @Override
    public boolean isArrayValue() {
        return true;
    }

    @Override
    public boolean isStaticValue() {
        return false;
    }

    @Override
    public Class<?> modeValueClass() {
        return String.class;
    }

    @Override
    public Object staticValue(String[] staticValues) {
        return null;
    }

    @Override
    public Object dynamicValue(UserIdentity loginDetails, String modeGroupCode) {
        String identityType = loginDetails.getIdentityType();
        // 如果不是后台管理用户，就不按销售组织字段进行权限控制
        if (!StringUtils.equals(identityType, "u")) {
            return null;
        }
        SalesOrgService orgService = applicationContext.getBean(SalesOrgService.class);
        AbstractCrmUserIdentity loginUserDetails = (AbstractCrmUserIdentity) loginDetails;
        //如果没有当前字段，就不进行权限控制
        if (!loginUserDetails.hasField("orgCode")) {
            return null;
        }
        Object orgCodeObject = loginUserDetails.invokeFieldValue("orgCode");
        if (orgCodeObject == null) {
            return null;
        }

        //根据orgCode查找上级，在查找销售组织
        OrgVo orgVo = orgVoService.findByOrgCode(orgCodeObject.toString());
        if (null == orgVo) {
            return null;
        }
        String salesOrgCode = null;
        if (StringUtils.isNotBlank(orgVo.getSalesOrgCode())) {
            salesOrgCode = orgVo.getSalesOrgCode();
        }

        if (StringUtils.isNotBlank(orgVo.getParentCode())) {
            //查找上级hr组织
            OrgVo upOrgVo = orgVoService.findByOrgCode(orgVo.getParentCode());
            if (null != upOrgVo && StringUtils.isNotBlank(upOrgVo.getSalesOrgCode())) {
                salesOrgCode = upOrgVo.getSalesOrgCode();
            }
        }

        if (StringUtils.isBlank(salesOrgCode)) {
            return null;
        }

        List<String> orgCodes = Lists.newArrayList(salesOrgCode);
        List<SalesOrg> children = orgService.findAllChildrenBySalesOrgCodes(orgCodes);
        orgCodes.addAll(children.stream().map(SalesOrg::getSalesOrgCode).distinct().collect(Collectors.toList()));
        return orgCodes.stream().toArray(String[]::new);
    }
}
