package com.biz.crm.mdm.business.sales.org.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.sales.org.local.service.SalesOrgBusinessVoService;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgBusinessTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgBusinessVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 销售组织信息和业态关系
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.13 20:09
 */
@Api(value = "MDM-销售组织", tags = "MDM-销售组织信息和业态")
@Slf4j
@RestController
@RequestMapping(value = {"/v1/salesOrg/salesOrgBusinessVo"})
public class SalesOrgBusinessVoController {

    @Autowired(required = false)
    private SalesOrgBusinessVoService salesOrgBusinessVoService;

    @ApiOperation("根据销售组织ID或销售组织编码获取业态信息")
    @GetMapping("/findBusinessFormatByIdOrCode")
    public Result<List<SalesOrgBusinessVo>> findBusinessFormatByIdOrCode(@ApiParam(name = "salesOrgId", value = "销售组织ID") @RequestParam(value = "salesOrgId", required = false) String salesOrgId,
                                                                         @ApiParam(name = "salesOrgCode", value = "销售组织编码") @RequestParam(value = "salesOrgCode", required = false) String salesOrgCode) {

        try {
            List<SalesOrgBusinessVo> trees = this.salesOrgBusinessVoService.findBusinessByIdOrCode(salesOrgId, salesOrgCode, SalesOrgBusinessTypeEnum.FORMAT);
            return Result.ok(trees);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    @ApiOperation("根据销售组织ID或销售组织编码获取业务单元信息")
    @GetMapping("/findBusinessUnitByIdOrCode")
    public Result<List<SalesOrgBusinessVo>> findBusinessUnitByIdOrCode(@ApiParam(name = "salesOrgId", value = "销售组织ID") @RequestParam(value = "salesOrgId", required = false) String salesOrgId,
                                                                       @ApiParam(name = "salesOrgCode", value = "销售组织编码") @RequestParam(value = "salesOrgCode", required = false) String salesOrgCode) {
        try {
            List<SalesOrgBusinessVo> trees = this.salesOrgBusinessVoService.findBusinessByIdOrCode(salesOrgId, salesOrgCode, SalesOrgBusinessTypeEnum.UNIT);
            return Result.ok(trees);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("根据销售组织ID集合或销售组织编码集合获取业务单元信息")
    @GetMapping("/findBusinessFormatByIdsOrCodes")
    public Result<List<SalesOrgBusinessVo>> findBusinessFormatByIdsOrCodes(
            @ApiParam(name = "salesOrgIdList", value = "销售组织ID集合") @RequestParam(value = "salesOrgIdList", required = false) List<String> salesOrgIdList,
            @ApiParam(name = "salesOrgCodeList", value = "销售组织编码集合") @RequestParam(value = "salesOrgCodeList", required = false) List<String> salesOrgCodeList) {
        try {
            List<SalesOrgBusinessVo> trees = this.salesOrgBusinessVoService.findBusinessByIdsOrCodes(salesOrgIdList, salesOrgCodeList, SalesOrgBusinessTypeEnum.FORMAT);
            return Result.ok(trees);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("根据销售组织ID集合或销售组织编码集合获取业务单元信息")
    @GetMapping("/findBusinessUnitIdsOrCodes")
    public Result<List<SalesOrgBusinessVo>> findBusinessUnitIdsOrCodes(
            @ApiParam(name = "salesOrgIdList", value = "销售组织ID集合") @RequestParam(value = "salesOrgIdList", required = false) List<String> salesOrgIdList,
            @ApiParam(name = "salesOrgCodeList", value = "销售组织编码集合") @RequestParam(value = "salesOrgCodeList", required = false) List<String> salesOrgCodeList) {
        try {
            List<SalesOrgBusinessVo> trees = this.salesOrgBusinessVoService.findBusinessByIdsOrCodes(salesOrgIdList, salesOrgCodeList, SalesOrgBusinessTypeEnum.UNIT);
            return Result.ok(trees);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
