package com.biz.crm.mdm.business.sales.org.local.controller;

import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgLazyTreeVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 销售组织
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.13 20:03
 */
@Api(value = "MDM-销售组织", tags = "MDM-销售组织懒加载树")
@Slf4j
@RestController
@RequestMapping(value = {"/v1/salesOrg/lazyTree"})
public class SalesOrgLazyTreeVoController {

    @Autowired(required = false)
    private SalesOrgLazyTreeVoService orgLazyTreeVoService;

    /**
     * 销售组织懒加载树
     *
     * @param treeDto
     * @return
     */
    @ApiOperation(value = "销售组织懒加载树", notes = "什么都不传返回第一层，传parentCode返回这个编码的下一级，传name模糊查询并且查询出所有上级再构建成树形，优先级parentCode > name")
    @GetMapping("/findByTreeDto")
    public Result<List<LazyTreeVo>> findByTreeDto(@ApiParam(name = "treeDto", value = "查询Dto") TreeDto treeDto) {
        try {
            //一级数据太多,这里不可放开,放开浏览器崩溃,输入名称搜索即可
            int maxSize = 25;
            List<LazyTreeVo> result = this.orgLazyTreeVoService.findByTreeDto(treeDto);
            if (CollectionUtils.isNotEmpty(result)
                    && result.size() > maxSize) {
                result = result.subList(0, maxSize);
            }
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
