package com.biz.crm.mdm.business.sales.org.local.controller;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.sales.org.local.service.SalesOrgSubComOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgSubComOrgDto;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;

/**
 * 销售组织与分子公司组织对应关系
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.13 20:09
 */
@Api(value = "MDM-销售组织与分子公司组织对应关系", tags = "MDM-销售组织与分子公司组织对应关系")
@Slf4j
@RestController
@RequestMapping(value = {"/v1/salesOrg/salesOrgSubComOrg"})
public class SalesOrgSubComOrgController {

    @Resource
    private SalesOrgSubComOrgService salesOrgSubComOrgService;

    @Autowired(required = false)
    private SalesOrgSubComOrgVoService salesOrgSubComOrgVoService;

    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<SalesOrgSubComOrgVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "dto", value = "销售组织与分子公司组织对应关系配置表") SalesOrgSubComOrgDto dto) {
        try {
            Page<SalesOrgSubComOrgVo> result = this.salesOrgSubComOrgService.findByConditions(pageable, dto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "批量新增")
    @PostMapping(value = {"/saveBatch"})
    public Result<?> saveBatch(@RequestBody List<SalesOrgSubComOrgDto> dtoList) {
        try {
            this.salesOrgSubComOrgService.saveBatch(dtoList);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "批量新增")
    @PostMapping(value = {"/listBySubComOrgCodeList"})
    public Result<List<SalesOrgSubComOrgVo>> listBySubComOrgCodeList(@RequestBody List<String> subComOrgCodeList) {
        try {
            List<SalesOrgSubComOrgVo> salesOrgSubComOrgVos =
                    this.salesOrgSubComOrgService.listBySubComOrgCodeList(subComOrgCodeList);
            return Result.ok(salesOrgSubComOrgVos);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量拉取 MDG 销售办公室关系主数据
     *
     * @param dto 请求参数
     * @return 组织渠道产品数据列表
     */
    @ApiOperation(value = "批量拉取 MDG 销售办公室关系主数据")
    @PostMapping(value = {"/pullSalesOfficeList"})
    public Result<?> pullSalesOfficeList(@RequestBody MasterDataMdgBaseDto dto) {
        try {
            this.salesOrgSubComOrgVoService.pullSalesOfficeList(dto);
            return Result.ok("批量拉取 MDG销售办公室关系主数据成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量拉取 MDG 公司地区和关系数据
     *
     * @param dto 请求参数
     * @return 公司地区和关系数据列表
     */
    @ApiOperation(value = "批量拉取 MDG 公司地区和关系数据数据")
    @PostMapping(value = {"/pullCompanyAreaList"})
    public Result<?> pullCompanyAreaList(@RequestBody MasterDataMdgBaseDto dto) {
        try {
            this.salesOrgSubComOrgVoService.pullCompanyAreaList(dto);
            return Result.ok("批量拉取 MDG 公司地区和关系数据成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据销售组织erp编码获取分子公司erp编码
     *
     * @param salesOrgErpCode 销售组织erp编码
     * @return 公司地区和关系数据列表
     */
    @ApiOperation(value = "根据销售组织erp编码获取分子公司erp编码")
    @GetMapping(value = {"/findBySaleOrgErpCode"})
    public Result<List<SalesOrgSubComOrgVo>> findBySaleOrgErpCode(@RequestParam("salesOrgErpCode") String salesOrgErpCode){
        try {
            return Result.ok(this.salesOrgSubComOrgService.findBySaleOrgErpCode(salesOrgErpCode));
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取全量分子公司关联销售组织数据
     *
     * @return
     */
    @ApiOperation(value = "获取全量分子公司关联销售组织数据")
    @GetMapping(value = "findAll")
    public Result<List<SalesOrgSubComOrgVo>> findAll(){
        try {
            return Result.ok(this.salesOrgSubComOrgService.findAll());
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 手动维度增值税
     * @param dtoList
     * @return {@link Result}<{@link ?}>
     */
    @ApiOperation(value = "手动维度增值税")
    @PostMapping(value = {"/setVatRate"})
    public Result setVatRate(@RequestBody SalesOrgSubComOrgDto dto) {
        try {
            this.salesOrgSubComOrgService.setVatRate(dto);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
