package com.biz.crm.mdm.business.sales.org.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgPaginationDto;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgTreeVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgTreeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 销售组织树状结构信息 http 接口
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.13 20:06
 */
@Api(value = "MDM-销售组织", tags = "MDM-销售组织树")
@Slf4j
@RestController
@RequestMapping(value = {"/v1/salesOrg/salesOrgTree"})
public class SalesOrgTreeVoController {

    @Autowired(required = false)
    private SalesOrgTreeVoService orgTreeVoService;

    @ApiOperation("查询所有销售组织树形结构（给后台使用），无筛选条件，全部返回（包含停用）")
    @GetMapping("/findAllStruTree")
    public Result<List<SalesOrgTreeVo>> findAllStruTree(SalesOrgPaginationDto orgPaginationDto) {

        try {
            List<SalesOrgTreeVo> trees = this.orgTreeVoService.findAllStruTreeByCondition(orgPaginationDto);
            return Result.ok(trees);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("查询所有销售组织树形结构（给后台使用），无筛选条件，全部返回（包含停用）")
    @GetMapping("/findBySalesOrgNameStruTree")
    public Result<List<SalesOrgTreeVo>> findBySalesOrgNameStruTree(SalesOrgPaginationDto orgPaginationDto) {
        try {
            List<SalesOrgTreeVo> trees = this.orgTreeVoService.findBySalesOrgNameStruTree(orgPaginationDto);
            return Result.ok(trees);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
