package com.biz.crm.mdm.business.sales.org.local.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe: 企业组织数据视图
 * @createTime 2022年09月13日 15:25:00
 */
@Component
public class SalesOrgDataViewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "mdm_sales_org_dataview";
    }

    @Override
    public String desc() {
        return "MDM销售组织数据视图";
    }

    @Override
    public String buildSql() {
        return "select mso.*, " +
                "       mso2.sales_org_name parentName, " +
                "       mso3.sales_org_name sales_institution_name  " +
                " from mdm_sales_org mso " +
                "         left join mdm_sales_org mso2 on mso.parent_code = mso2.sales_org_code " +
                " and mso2.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "         left join mdm_sales_org mso3 on mso.sales_institution_code = mso3.sales_org_code " +
                " and mso3.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                " where mso.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "  and mso.tenant_code = :tenantCode " +
                "  and mso.rule_code like concat(:ruleCode,'%') ";
    }
}
