package com.biz.crm.mdm.business.sales.org.local.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe: 销售组织与分子公司对应关系数据视图
 * @createTime 2022年09月13日 15:25:00
 */
@Component
public class SalesOrgSubComDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "mdm_sales_org_sub_com_data_view";
    }

    @Override
    public String desc() {
        return "MDM销售组织与分子公司对应关系数据视图";
    }

    @Override
    public String buildSql() {
        return "SELECT distinct t.*  FROM mdm_sales_org_sub_com_org t" + "  WHERE  t.del_flag = '"
            + DelFlagStatusEnum.NORMAL.getCode() + "' " + "  AND t.tenant_code = :tenantCode ";
    }
}

