package com.biz.crm.mdm.business.sales.org.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.List;

/**
 * 销售组织表实体类
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.10.28 14:43
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_sales_org")
@ApiModel("销售组织表实体类")
@Table(name = "mdm_sales_org", indexes = {
        @Index(name = "mdm_sales_org_index1", columnList = "sales_org_code", unique = true),
        @Index(name = "mdm_sales_org_index2", columnList = "rule_code", unique = false),
        @Index(name = "mdm_sales_org_index3", columnList = "parent_code", unique = false),
        @Index(name = "mdm_sales_org_index4", columnList = "erp_code", unique = false),
        @Index(name = "mdm_sales_org_index5", columnList = "sales_institution_code", unique = false),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_sales_org", comment = "销售组织")
@Entity
public class SalesOrg extends TenantFlagTreeOpEntity {

    private static final long serialVersionUID = -6564517827900942851L;

    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元编码")
    @TableField(value = "business_unit_code")
    @Column(name = "business_unit_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务单元编码'")
    private String businessUnitCode;

    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @TableField(value = "business_format_code")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    @ApiModelProperty("所属销售机构编码")
    @TableField(value = "sales_institution_code")
    @Column(name = "sales_institution_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售机构编码 '")
    private String salesInstitutionCode;

    @ApiModelProperty("销售组织(组)编码")
    @TableField(value = "sales_org_code")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 销售组织(组)编码 '")
    private String salesOrgCode;

    @ApiModelProperty("销售组织(组)名称")
    @TableField(value = "sales_org_name")
    @Column(name = "sales_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 销售组织(组)名称 '")
    private String salesOrgName;

    @ApiModelProperty("渠道编码")
    @TableField(value = "channel_code")
    @Column(name = "channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 渠道编码 '")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    @TableField(value = "channel_name")
    @Column(name = "channel_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 渠道名称 '")
    private String channelName;

    @ApiModelProperty("销售组织层级")
    @TableField(value = "sales_org_Level")
    @Column(name = "sales_org_level", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 销售组织层级 '")
    private String salesOrgLevel;

    @ApiModelProperty("销售组织类型")
    @TableField(value = "sales_org_type")
    @Column(name = "sales_org_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 销售组织类型 '")
    private String salesOrgType;

    @ApiModelProperty("销售组织描述")
    @TableField(value = "sales_org_desc")
    @Column(name = "sales_org_desc", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 销售组织描述 '")
    private String salesOrgDesc;

    @ApiModelProperty("上级销售组织编码")
    @TableField(value = "parent_code")
    @Column(name = "parent_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 上级销售组织编码 '")
    private String parentCode;

    @ApiModelProperty("对应SAP销售组织编码")
    @TableField(value = "erp_code")
    @Column(name = "erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 对应SAP销售组织编码 '")
    private String erpCode;

    @ApiModelProperty("对应上级SAP销售组织编码")
    @TableField(value = "parent_erp_code")
    @Column(name = "parent_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 对应上级SAP销售组织编码 '")
    private String parentErpCode;

    @ApiModelProperty(name = "parent", value = "父节点")
    @TableField(exist = false)
    @Transient
    private SalesOrg parent;

    @ApiModelProperty(name = "children", value = "子节点")
    @TableField(exist = false)
    @Transient
    private List<SalesOrg> children;

    @ApiModelProperty(name = "parentName", value = "上级销售组织名称")
    @TableField(exist = false)
    @Transient
    private String parentName;

    @ApiModelProperty(name = "unionName", value = "编码/名称")
    @TableField(exist = false)
    @Transient
    private String unionName;

    @ApiModelProperty(name = "unionNameExt", value = "编码/名称/渠道/业态")
    @TableField(exist = false)
    @Transient
    private String unionNameExt;

}
