package com.biz.crm.mdm.business.sales.org.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 销售组织和业态关系实体
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.10.28 14:43
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_sales_org_business")
@ApiModel("销售组织和业态关系实体类")
@Table(name = "mdm_sales_org_business", indexes = {
        @Index(name = "mdm_sales_org_business_index1", columnList = "sales_org_code", unique = false),
        @Index(name = "mdm_sales_org_business_index2", columnList = "business_code", unique = false),
})
@org.hibernate.annotations.Table(appliesTo = "mdm_sales_org_business", comment = "销售组织和业态或业务单元关系")
@Entity
public class SalesOrgBusiness extends TenantFlagOpEntity {

    private static final long serialVersionUID = 8288769275813571815L;
    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "salesOrgCode", value = "销售组织编码")
    @TableField(value = "sales_org_code")
    @Column(name = "sales_org_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 销售组织编码 '")
    private String salesOrgCode;

    /**
     * 编码
     */
    @TableField(value = "business_code")
    @ApiModelProperty(name = "businessCode", value = "编码")
    @Column(name = "business_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 编码 '")
    private String businessCode;

    /**
     * 名称
     */
    @TableField(value = "business_name")
    @ApiModelProperty(name = "businessName", value = "名称")
    @Column(name = "business_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 名称 '")
    private String businessName;

    /**
     * 类型
     */
    @TableField(value = "business_type")
    @ApiModelProperty(name = "businessType", value = "类型")
    @Column(name = "business_type", nullable = false, length = 8, columnDefinition = "VARCHAR(32) COMMENT ' 类型 '")
    private String businessType;

    /**
     * 显示顺序
     */
    @TableField(value = "sort_num")
    @ApiModelProperty(name = "sortNum", value = "显示顺序")
    @Column(name = "sort_num", length = 5, columnDefinition = "int(5) default 999 null COMMENT '显示顺序'")
    private Integer sortNum;

}
