package com.biz.crm.mdm.business.sales.org.local.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 销售组织与分子公司组织对应关系
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.10.28 14:43
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_sales_org_sub_com_org")
@ApiModel("销售组织与分子公司组织对应关系")
@Table(name = "mdm_sales_org_sub_com_org")
@org.hibernate.annotations.Table(appliesTo = "mdm_sales_org_sub_com_org", comment = "销售组织与分子公司组织对应关系")
@Entity
public class SalesOrgSubComOrg extends TenantFlagOpEntity {

    private static final long serialVersionUID = 7795382696194539841L;

    /**
     * 分子公司组织编码
     */
    @ApiModelProperty("分子公司组织编码")
    @TableField(value = "sub_com_org_code")
    @Column(name = "sub_com_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 分子公司组织编码 '")
    private String subComOrgCode;

    /**
     * 分子公司组织名称
     */
    @TableField(value = "sub_com_org_name")
    @ApiModelProperty("分子公司组织名称")
    @Column(name = "sub_com_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT ' 分子公司组织名称 '")
    private String subComOrgName;

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    @TableField(value = "sales_org_code")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 销售组织编码 '")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    @TableField(value = "sales_org_name")
    @Column(name = "sales_org_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT ' 销售组织名称 '")
    private String salesOrgName;

    @ApiModelProperty("增值税税率")
    @Column(name = "vat_rate", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '增值税税率 '")
    private BigDecimal vatRate;
}
