package com.biz.crm.mdm.business.sales.org.local.jobs;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.mdm.business.sales.org.local.service.SalesOrgSubComOrgVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Description 同步分子公司与销售机构
 * @Author YangWei
 * @Date 2023/3/6 下午2:43
 */
@Slf4j
@Service
public class SalesOrgSubComOrgSyncXxJob {

    @Autowired(required = false)
    private SalesOrgSubComOrgVoService salesOrgSubComOrgVoService;

    /**
     * 同步分子公司与销售机构 每天4点自动执行
     */
    @DynamicTaskService(cornExpression = "0 0 4 * * ?", taskDesc = "同步分子公司与销售机构")
    public void autoSyncXxlJob() {
        //TODO  需要改成  定时任务分片+redis锁
        log.info("=====>    销售组织同步[{}] start    <=====", DateUtil.dateStrNowAll());
        MasterDataMdgBaseDto dto = new MasterDataMdgBaseDto();
        dto.setFullPullFlag(BooleanEnum.TRUE.getCapital());
        this.salesOrgSubComOrgVoService.pullCompanyAreaList(dto);
        this.salesOrgSubComOrgVoService.pullSalesOfficeList(dto);
        log.info("=====>    销售组织同步[{}] end    <=====", DateUtil.dateStrNowAll());
    }
}