package com.biz.crm.mdm.business.sales.org.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.mdm.business.sales.org.local.entity.SalesOrgBusiness;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgBusinessVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 销售组织实体 mybatis-plus接口类
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.10.28 15:34
 */
public interface SalesOrgBusinessMapper extends BaseMapper<SalesOrgBusiness> {
    /**
     * 根据销售组织ID或销售组织编码;获取业态或业务单元信息
     *
     * @param salesOrgId   销售组织ID
     * @param salesOrgCode 销售组织编码
     * @param code         业务类型
     * @param tenantCode   租户编码
     * @return java.util.List<com.biz.crm.mdm.business.org.sdk.vo.SalesOrgBusinessFormatVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.16 16:19
     */
    List<SalesOrgBusinessVo> findBusinessByIdOrCode(@Param("salesOrgId") String salesOrgId, @Param("salesOrgCode") String salesOrgCode, @Param("code") String code, @Param("tenantCode") String tenantCode);

    /**
     * 根据销售组织ID集合或销售组织编码集合;获取业态或业务单元信息
     *
     * @param salesOrgIdList   销售组织ID集合
     * @param salesOrgCodeList 销售组织编码集合
     * @param code         业务类型
     * @param tenantCode   租户编码
     * @return java.util.List<com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgBusinessVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.16 17:06
     */
    List<SalesOrgBusinessVo> findBusinessByIdsOrCodes(@Param("salesOrgIdList") List<String> salesOrgIdList, @Param("salesOrgCodeList") List<String> salesOrgCodeList, @Param("code") String code, @Param("tenantCode") String tenantCode);
}
