package com.biz.crm.mdm.business.sales.org.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.sales.org.local.entity.SalesOrg;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgPaginationDto;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgSelectDto;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 销售组织实体 mybatis-plus接口类
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.10.28 15:34
 */
public interface SalesOrgMapper extends BaseMapper<SalesOrg> {

    /**
     * 根据 Org 主键查询详细信息（包括关联表）
     *
     * @param id
     * @param delFlag
     * @return
     */
    SalesOrg findDetailsById(@Param("id") String id, @Param("delFlag") DelFlagStatusEnum delFlag);

    /**
     * 根据 orgCode 编码 查询
     *
     * @param orgCode
     * @param tenantCode
     * @param delFlag
     * @return
     */
    SalesOrg findByOrgCode(@Param("orgCode") String orgCode, @Param("tenantCode") String tenantCode, @Param("delFlag") DelFlagStatusEnum delFlag);

    /**
     * 分页查询
     *
     * @param page
     * @param paginationDto
     * @param delFlag
     * @return
     */
    //@SqlPrivilege
    Page<SalesOrg> findByConditions(Page<SalesOrg> page, @Param("dto") SalesOrgPaginationDto paginationDto, @Param("delFlag") DelFlagStatusEnum delFlag);

    /**
     * 根据 Org 主键集合查询详细信息（包括关联表）
     *
     * @param ids
     * @param delFlag
     * @return
     */
    List<SalesOrg> findDetailsByIds(@Param("ids") List<String> ids, @Param("delFlag") DelFlagStatusEnum delFlag);

    /**
     * 根据 orgCode集合查询详细信息（包括关联表）
     *
     * @param orgCodes
     * @param tenantCode
     * @param delFlag
     * @return
     */
    List<SalesOrg> findByOrgCodes(@Param("orgCodes") List<String> orgCodes, @Param("tenantCode") String tenantCode, @Param("delFlag") DelFlagStatusEnum delFlag);

    /**
     * 按父节点code集合查询
     *
     * @param parentCodes
     * @param tenantCode
     * @param delFlag
     * @return
     */
    List<SalesOrg> findByParentCodes(@Param("parentCodes") List<String> parentCodes, @Param("tenantCode") String tenantCode, @Param("delFlag") DelFlagStatusEnum delFlag);

    /**
     * 按ruleCode 集合查询所有子集合的销售组织code
     *
     * @param ruleCodes
     * @param tenantCode
     * @param delFlag
     * @return
     */
    List<String> findChildrenOrgCodeByRuleCodes(@Param("ruleCodes") List<String> ruleCodes, @Param("tenantCode") String tenantCode, @Param("delFlag") DelFlagStatusEnum delFlag);

    /**
     * 按ruleCode 集合查询所有子集合的销售组织
     *
     * @param ruleCodes
     * @param tenantCode
     * @param delFlag
     * @return
     */
    List<SalesOrg> findChildrenByRuleCodes(@Param("ruleCodes") List<String> ruleCodes, @Param("tenantCode") String tenantCode, @Param("delFlag") DelFlagStatusEnum delFlag);

    /**
     * 分页通过ruleCodes 查询子节点信息
     *
     * @param page
     * @param ruleCodes
     * @param tenantCode
     * @param delFlag
     * @return
     */
    Page<SalesOrg> findChildrenByRuleCodes(Page<SalesOrg> page, @Param("ruleCodes") List<String> ruleCodes, @Param("tenantCode") String tenantCode, @Param("delFlag") DelFlagStatusEnum delFlag);

    /**
     * 查询销售组织懒加载数据
     *
     * @param enableStatus    启用状态
     * @param topOnly         传true只查第一层
     * @param parentCode      只查询该编码下一级
     * @param codeList        只查询这些编码
     * @param ruleCodeList    只查询这些降维编码
     * @param excludeRuleCode 排除这个降维编码的下级
     * @param tenantCode
     * @param delFlag
     * @return
     */
    List<LazyTreeVo> findOrgLazyTreeList(@Param("enableStatus") String enableStatus,
                                         @Param("topOnly") Boolean topOnly,
                                         @Param("parentCode") String parentCode,
                                         @Param("codeList") List<String> codeList,
                                         @Param("ruleCodeList") List<String> ruleCodeList,
                                         @Param("excludeRuleCode") String excludeRuleCode,
                                         @Param("tenantCode") String tenantCode,
                                         @Param("delFlag") DelFlagStatusEnum delFlag);

    /**
     * 查找parentCode不为空但找不到对应上级的数据(包括已被删除的数据),设置parentCode为null
     *
     * @param tenantCode
     * @param delFlag
     */
    void updateOrphanParentCodeNull(@Param("tenantCode") String tenantCode, @Param("delFlag") DelFlagStatusEnum delFlag);

    Page<SalesOrg> findBySalesSelectDto(Page<SalesOrg> page,@Param("dto")  SalesOrgSelectDto dto);

    /**
     * 根据erp编码查询销售组织全部信息
     *
     * @param erpCodes erp编码列表
     * @param tenantCode 租户编码
     * @return List<SalesOrgVo>
     */
    List<SalesOrgVo> getSalesMapByErpCodes(@Param("erpCodes") List<List<String>> erpCodes,@Param("tenantCode") String tenantCode);

    /**
     * 根据tpm编码查询销售组织全部信息
     *
     * @param tpmCodes tpm编码列表
     * @param tenantCode 租户编码
     * @return List<SalesOrgVo>
     */
    List<SalesOrgVo> getSalesMapByTpmCodes(@Param("tpmCodes") List<List<String>> tpmCodes,@Param("tenantCode") String tenantCode);

    /**
     * 根据销售组织编码集合查询对应名称
     *
     * @param salesOrgCodes 销售组织编码
     * @param tenantCode    租户编码
     * @return List<SalesOrgVo>
     */
    List<SalesOrgVo> findNameBySalesOrgCodes(@Param("salesOrgCodes") List<List<String>> salesOrgCodes,@Param("tenantCode") String tenantCode);

    /**
     * erp编码查询名称
     * @param erpCodes
     * @param tenantCode
     * @return {@link List}<{@link SalesOrgVo}>
     */
    List<SalesOrgVo> findNameByErpCodes(@Param("erpCodes") List<String> erpCodes, @Param("tenantCode") String tenantCode);

    /**
     * 条件查询
     * @param dto
     * @return {@link List}<{@link SalesOrgVo}>
     */
    List<SalesOrgVo> findBySalesOrgSelectDto(@Param("dto") SalesOrgSelectDto dto);

    /**
     * 根据类型查询销售机构
     * @param page
     * @param dto
     * @return {@link Page}<{@link SalesOrg}>
     */
    Page<SalesOrg> findBySalesOrgLevelType(Page<SalesOrg> page, @Param("dto") SalesOrgPaginationDto dto);

    /**
     * 模糊查询
     * @param page
     * @param codeOrNameLike
     * @param tenantCode
     * @return
     */
    Page<SalesOrg> findByOrgCodeLikeOrOrgNameLike(Page<SalesOrg> page, @Param("codeOrNameLike") String codeOrNameLike, @Param("tenantCode") String tenantCode);
}
