package com.biz.crm.mdm.business.sales.org.local.repository;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgBusinessTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.sales.org.local.entity.SalesOrgBusiness;
import com.biz.crm.mdm.business.sales.org.local.mapper.SalesOrgBusinessMapper;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgBusinessVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;

/**
 * 条件字段分类 数据层
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.10.28 16:18
 */
@Repository
public class SalesOrgBusinessRepository extends ServiceImpl<SalesOrgBusinessMapper, SalesOrgBusiness> {
    /**
     * 根据销售组织ID或销售组织编码;获取业态或业务单元信息
     *
     * @param salesOrgId   销售组织ID
     * @param salesOrgCode 销售组织编码
     * @param code
     * @return java.util.List<com.biz.crm.mdm.business.org.sdk.vo.SalesOrgBusinessFormatVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.16 16:19
     */
    public List<SalesOrgBusinessVo> findBusinessByIdOrCode(String salesOrgId, String salesOrgCode, String code) {
        if (StringUtils.isEmpty(code)) {
            return Collections.emptyList();
        }
        if (StringUtils.isEmpty(salesOrgId)
                && StringUtils.isEmpty(salesOrgCode)) {
            return Collections.emptyList();
        }
        return this.baseMapper.findBusinessByIdOrCode(salesOrgId, salesOrgCode, code, TenantUtils.getTenantCode());
    }

    /**
     * 根据销售组织ID集合或销售组织编码集合;获取业态或业务单元信息
     *
     * @param salesOrgIdList   销售组织ID集合
     * @param salesOrgCodeList 销售组织编码集合
     * @param code
     * @return java.util.List<com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgBusinessVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.16 17:06
     */
    public List<SalesOrgBusinessVo> findBusinessByIdsOrCodes(List<String> salesOrgIdList, List<String> salesOrgCodeList, String code) {
        if (StringUtils.isEmpty(code)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(salesOrgIdList)
                && CollectionUtils.isEmpty(salesOrgCodeList)) {
            return Collections.emptyList();
        }
        return this.baseMapper.findBusinessByIdsOrCodes(salesOrgIdList, salesOrgCodeList, code, TenantUtils.getTenantCode());
    }

    public List<SalesOrgBusiness> findSalesOrgBusinessByCodeList(List<String> salesOrgCodeList,
                                                                 SalesOrgBusinessTypeEnum businessTypeEnum) {
        if (CollectionUtils.isEmpty(salesOrgCodeList)
                || Objects.isNull(businessTypeEnum)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(SalesOrgBusiness::getTenantCode, TenantUtils.getTenantCode())
                .eq(SalesOrgBusiness::getBusinessType, businessTypeEnum.getCode())
                .in(SalesOrgBusiness::getSalesOrgCode, salesOrgCodeList)
                .list();
    }
}
