package com.biz.crm.mdm.business.sales.org.local.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.sales.org.local.entity.SalesOrgSubComOrg;
import com.biz.crm.mdm.business.sales.org.local.mapper.SalesOrgSubComOrgMapper;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgSubComOrgDto;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.util.StringUtils;

/**
 * @author huojia
 * @date 2022年11月21日 18:52
 */
@Repository
public class SalesOrgSubComOrgRepository extends ServiceImpl<SalesOrgSubComOrgMapper, SalesOrgSubComOrg> {

    @Autowired
    private SalesOrgSubComOrgMapper salesOrgSubComOrgMapper;

    /**
     * 根据分子公司客户编码查询对应关系
     *
     * @param subComOrgCodeList
     * @return java.util.List<com.biz.crm.mdm.business.sales.org.local.entity.SalesOrgSubComOrg>
     * @author huojia
     * @date 2022/11/22 14:28
     **/
    public List<SalesOrgSubComOrg> listBySubComOrgCodeList(List<String> subComOrgCodeList) {
        if (CollectionUtils.isEmpty(subComOrgCodeList)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery().in(SalesOrgSubComOrg::getSubComOrgCode, subComOrgCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
    }

    /**
     * MDG主数据拉取销售办公室关系主数据
     */
    public List<SalesOrgSubComOrg> findBySalesOrgCodeLists(List<String> salesOrgCodeList) {
        if (CollectionUtils.isEmpty(salesOrgCodeList)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .eq(SalesOrgSubComOrg::getTenantCode, TenantUtils.getTenantCode())
                .in(SalesOrgSubComOrg::getSubComOrgCode, salesOrgCodeList)
                .list();
    }

    public List<SalesOrgSubComOrg> findBySaleOrgErpCode(String salesOrgErpCode) {
        if (StringUtil.isEmpty(salesOrgErpCode)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .eq(SalesOrgSubComOrg::getSalesOrgCode, salesOrgErpCode)
                .eq(SalesOrgSubComOrg::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    /**
     * 根据客户编码查询分子公司编码
     *
     * @param erpCode
     * @return Boolean
     * @author huojia
     * @date 2022/12/5 20:32
     **/
    public List<SalesOrgSubComOrg> findByCustomerClass(String erpCode) {
        if (StringUtil.isEmpty(erpCode)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .eq(SalesOrgSubComOrg::getSubComOrgCode, erpCode)
                .eq(SalesOrgSubComOrg::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }


    /**
     * 分页查询数据
     *
     * @param dto 送达方查询参数
     * @param dto 实体对象
     * @return
     */
    public Page<SalesOrgSubComOrgVo> findByConditions(Page<SalesOrgSubComOrgVo> pageable, SalesOrgSubComOrgDto dto) {
        // 过滤多租户
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.salesOrgSubComOrgMapper.findByConditions(pageable, dto);
    }

    public List<SalesOrgSubComOrg> findAll() {
        return this.lambdaQuery()
                .eq(SalesOrgSubComOrg::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    public List<SalesOrgSubComOrg> findErpCodeListByCustomerClass(List<String> erpCodeList) {
        if (CollectionUtils.isEmpty(erpCodeList)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .in(SalesOrgSubComOrg::getSubComOrgCode, erpCodeList)
                .eq(SalesOrgSubComOrg::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }
}
