package com.biz.crm.mdm.business.sales.org.local.service;

import com.biz.crm.mdm.business.sales.org.local.entity.SalesOrgBusiness;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgBusinessTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgBusinessVo;

import java.util.List;

/**
 * 销售组织信息和业态关系
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.10.28 16:07
 */
public interface SalesOrgBusinessVoService {
    /**
     * 根据销售组织ID或销售组织编码;获取业态或业务单元信息
     *
     * @param salesOrgId   销售组织ID
     * @param salesOrgCode 销售组织编码
     * @param typeEnum     业务类型
     * @return java.util.List<com.biz.crm.mdm.business.org.sdk.vo.SalesOrgBusinessFormatVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.16 16:19
     */
    List<SalesOrgBusinessVo> findBusinessByIdOrCode(String salesOrgId, String salesOrgCode, SalesOrgBusinessTypeEnum typeEnum);

    /**
     * 根据销售组织ID集合或销售组织编码集合;获取业态或业务单元信息
     *
     * @param salesOrgIdList   销售组织ID集合
     * @param salesOrgCodeList 销售组织编码集合
     * @param typeEnum         业务类型
     * @return java.util.List<com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgBusinessVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.16 17:06
     */
    List<SalesOrgBusinessVo> findBusinessByIdsOrCodes(List<String> salesOrgIdList, List<String> salesOrgCodeList, SalesOrgBusinessTypeEnum typeEnum);

    /**
     * 根据销售组织编码和业务类型获取关联信息
     *
     * @param salesOrgCodeList 销售组织编码
     * @param businessTypeEnum 业务类型
     * @return java.util.List<com.biz.crm.mdm.business.sales.org.local.entity.SalesOrgBusiness>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023.1.9 14:34
     */
    List<SalesOrgBusiness> findSalesOrgBusinessByCodeList(List<String> salesOrgCodeList,
                                                          SalesOrgBusinessTypeEnum businessTypeEnum);

    /**
     * 批量保存和更新
     *
     * @param saveList
     * @param updateList
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023.1.9 14:38
     */
    void saveOrUpdateBatch(List<SalesOrgBusiness> saveList, List<SalesOrgBusiness> updateList);
}
