package com.biz.crm.mdm.business.sales.org.local.service;


import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 销售组织与分子公司组织对应关系
 *
 * @describe: 简述
 * @author: 杜涛涛
 * @version: v2.0.0
 * @date: 2022.12.25 13:07
 */

public interface SalesOrgSubComOrgVoService {

    /**
     * 批量拉取 MDG 销售办公室关系主数据(MDG)
     * @param dto
     * @author 杜涛涛
     * @date 2022/12/5 20:32
     **/
     void pullSalesOfficeList(MasterDataMdgBaseDto dto);

    /**
     * 批量拉取 MDG 公司地区和关系数据(MDG)
     * @param dto
     * @author huojia
     * @date 2022/12/5 20:32
     **/
    void pullCompanyAreaList(MasterDataMdgBaseDto dto);

    /**
     * 根据客户编码查询分子公司编码
     * @param erpCode
     * @author huojia
     * @date 2022/12/5 20:32
     * @return Boolean
     **/
    Boolean findByCustomerClass(String erpCode);

    /**
     * 根据客户编码查询分子公司编码
     * @param erpCodeList
     * @author huojia
     * @date 2022/12/5 20:32
     * @return Boolean
     **/
    Set<String> findErpCodeListByCustomerClass(List<String> erpCodeList);
}
