package com.biz.crm.mdm.business.sales.org.local.service.impl;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.sales.org.local.service.SalesOrgMdgService;
import com.biz.crm.mdm.business.sales.org.local.service.SalesOrgService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgBaseDto;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 销售组织自动更新定时任务     job
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class SalesOrgAutoSyncXxlJob {


    @Autowired(required = false)
    private SalesOrgMdgService salesOrgMdgService;
    @Autowired(required = false)
    private SalesOrgService salesOrgService;
    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 销售组织自动更新定时任务 每天4点自动执行
     */
    @DynamicTaskService(cornExpression = "0 0 4 * * ?", taskDesc = "销售组织自动更新定时任务")
    public void autoSyncXxlJob() {
        loginUserService.refreshAuthentication(null);
        //TODO  需要改成  定时任务分片+redis锁
        log.info("=====>    销售组织同步[{}] start    <=====", DateUtil.dateStrNowAll());
        MasterDataMdgBaseDto parentDto = new MasterDataMdgBaseDto();
        parentDto.setFullPullFlag(BooleanEnum.TRUE.getCapital());
        salesOrgMdgService.pullSalesOrgParentList(parentDto, false);
        MasterDataMdgBaseDto salesOrgDto = new MasterDataMdgBaseDto();
        salesOrgDto.setFullPullFlag(BooleanEnum.TRUE.getCapital());
        salesOrgMdgService.pullSalesOrgList(salesOrgDto, false);
        salesOrgService.updateRuleCode(loginUserService.getLoginUser());
        log.info("=====>    销售组织同步[{}] end    <=====", DateUtil.dateStrNowAll());

    }

}
