package com.biz.crm.mdm.business.sales.org.local.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.sales.org.local.entity.SalesOrgSubComOrg;
import com.biz.crm.mdm.business.sales.org.local.mapper.SalesOrgSubComOrgMapper;
import com.biz.crm.mdm.business.sales.org.local.repository.SalesOrgSubComOrgRepository;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgSubComOrgDto;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;

/**
 * @author huojia
 * @date 2022年11月21日 18:36
 */
@Slf4j
@Service
public class SalesOrgSubComOrgServiceImpl implements SalesOrgSubComOrgService {

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    @Resource
    private SalesOrgSubComOrgMapper salesOrgSubComOrgMapper;

    @Resource
    private SalesOrgSubComOrgRepository salesOrgSubComOrgRepository;

    /**
     * 分页批量查询
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo>
     * @author huojia
     * @date 2022/11/21 18:38
     **/
    @Override
    public Page<SalesOrgSubComOrgVo> findByConditions(Pageable pageable, SalesOrgSubComOrgDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
        dto = Optional.ofNullable(dto).orElse(new SalesOrgSubComOrgDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page<SalesOrgSubComOrgVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return salesOrgSubComOrgRepository.findByConditions(page, dto);
    }

    /**
     * 批量新增
     *
     * @param salesOrgSubComOrgDtoList
     * @author huojia
     * @date 2022/11/21 18:43
     **/
    @Override
    public void saveBatch(List<SalesOrgSubComOrgDto> salesOrgSubComOrgDtoList) {
        Validate.notEmpty(salesOrgSubComOrgDtoList, "新增销售组织与分子公司组织对应关系失败，数据不能为空！");
        this.createValidate(salesOrgSubComOrgDtoList);
        List<SalesOrgSubComOrg> salesOrgSubComOrgList = (List<SalesOrgSubComOrg>) this.nebulaToolkitService.copyCollectionByWhiteList(
                salesOrgSubComOrgDtoList, SalesOrgSubComOrgDto.class, SalesOrgSubComOrg.class, LinkedHashSet.class, ArrayList.class
        );
        salesOrgSubComOrgRepository.saveBatch(salesOrgSubComOrgList);
    }

    /**
     * 根据分子公司客户编码查询对应关系
     *
     * @param subComOrgCodeList
     * @return java.util.List<com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo>
     * @author huojia
     * @date 2022/11/22 14:26
     **/
    @Override
    public List<SalesOrgSubComOrgVo> listBySubComOrgCodeList(List<String> subComOrgCodeList) {
        if (CollectionUtils.isEmpty(subComOrgCodeList)) {
            return Lists.newArrayList();
        }
        List<SalesOrgSubComOrg> salesOrgSubComOrgList = this.salesOrgSubComOrgRepository.listBySubComOrgCodeList(subComOrgCodeList);
        if (CollectionUtils.isEmpty(salesOrgSubComOrgList)) {
            return Lists.newArrayList();
        }
        return (List<SalesOrgSubComOrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                salesOrgSubComOrgList, SalesOrgSubComOrg.class, SalesOrgSubComOrgVo.class, LinkedHashSet.class, ArrayList.class
        );
    }

    @Override
    public List<SalesOrgSubComOrgVo> findBySaleOrgErpCode(String salesOrgErpCode) {
        if (StringUtils.isEmpty(salesOrgErpCode)) {
            return Lists.newArrayList();
        }
        List<SalesOrgSubComOrg> salesOrgSubComOrgList = this.salesOrgSubComOrgRepository.findBySaleOrgErpCode(salesOrgErpCode);
        if (StringUtils.isEmpty(salesOrgErpCode)) {
            return Lists.newArrayList();
        }
        return (List<SalesOrgSubComOrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                salesOrgSubComOrgList, SalesOrgSubComOrg.class, SalesOrgSubComOrgVo.class, LinkedHashSet.class, ArrayList.class
        );
    }

    @Override
    public List<SalesOrgSubComOrgVo> findAll() {
        List<SalesOrgSubComOrg> entityList = this.salesOrgSubComOrgRepository.findAll();
        return (List<SalesOrgSubComOrgVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                entityList, SalesOrgSubComOrg.class, SalesOrgSubComOrgVo.class, LinkedHashSet.class, ArrayList.class
        );
    }


    /**
     * 新增校验
     *
     * @param salesOrgSubComOrgDtoList
     * @author huojia
     * @date 2022/11/21 18:54
     **/
    private void createValidate(List<SalesOrgSubComOrgDto> salesOrgSubComOrgDtoList) {
        salesOrgSubComOrgDtoList.forEach(salesOrgSubComOrgDto -> {
            Validate.notEmpty(salesOrgSubComOrgDto.getSubComOrgCode(), "分子公司组织编码不能为空！");
            Validate.notEmpty(salesOrgSubComOrgDto.getSubComOrgName(), "分子公司组织名称不能为空！");
            Validate.notEmpty(salesOrgSubComOrgDto.getSalesOrgCode(), "销售组织编码不能为空！");
            Validate.notEmpty(salesOrgSubComOrgDto.getSalesOrgName(), "销售组织名称不能为空！");
            salesOrgSubComOrgDto.setTenantCode(TenantUtils.getTenantCode());
            salesOrgSubComOrgDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            salesOrgSubComOrgDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
    }

    /**
     * 设置增值税税率
     * @param dto
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void setVatRate(SalesOrgSubComOrgDto dto) {
        Assert.hasText(dto.getId(), "主键ID不能为空");
        Assert.notNull(dto.getVatRate(),"增值税率不能为空");
        SalesOrgSubComOrg entity = this.salesOrgSubComOrgRepository.getById(dto.getId());
        entity.setVatRate(dto.getVatRate());
        this.salesOrgSubComOrgRepository.updateById(entity);
    }
}
