package com.biz.crm.mdm.business.sales.org.local.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.mdm.business.dictionary.sdk.constant.DictConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.local.entity.SalesOrg;
import com.biz.crm.mdm.business.sales.org.local.service.SalesOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgPaginationDto;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgTreeVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgTreeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author hecheng
 * @description: 组织树形vo service实现
 * @date 2021/10/13 下午3:02
 */
@Service
public class SalesOrgTreeVoServiceImpl implements SalesOrgTreeVoService {

    @Autowired(required = false)
    private SalesOrgService orgService;
    @Autowired(required = false)
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private DictToolkitService dictToolkitService;


    @Override
    public List<SalesOrgTreeVo> findBySalesOrgNameStruTree(SalesOrgPaginationDto dto) {
        //orgName 为空时是查询全部 不用做空校验
        List<SalesOrgTreeVo> tree = new ArrayList<>();
        if (StringUtils.isEmpty(dto.getSalesOrgName())
                && StringUtils.isEmpty(dto.getCodeOrgName())) {
            dto.setSalesOrgLevel(SalesOrgLevelTypeEnum.MECHANISM.getCode());
        }
        List<SalesOrg> list = this.orgService.findByConditions(dto);
        if (CollectionUtils.isEmpty(list)) {
            return tree;
        }
        List<String> ruleCodes = list.stream().map(SalesOrg::getRuleCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ruleCodes)) {
            list = this.orgService.findAllParentByRuleCodes(ruleCodes);
        }
        if (CollectionUtils.isEmpty(list)) {
            return tree;
        }
        List<SalesOrgTreeVo> collect = (List<SalesOrgTreeVo>) this.nebulaToolkitService.copyCollectionByBlankList(list, SalesOrg.class, SalesOrgTreeVo.class, HashSet.class, ArrayList.class);

        Map<String, String> salesOrgTypeMap = dictToolkitService.findMapByDictTypeCode(DictConstant.MDM_SALES_ORG_TYPE);
        Map<String, String> salesOrgLevelMap = dictToolkitService.findMapByDictTypeCode(DictConstant.MDM_SALES_ORG_LEVEL);
        if (CollectionUtil.isNotEmpty(salesOrgTypeMap)) {
            collect.stream()
                    .filter(k -> StringUtils.isNotBlank(k.getSalesOrgType()))
                    .forEach(vo -> {
                        vo.setSalesOrgTypeName(salesOrgTypeMap.get(vo.getSalesOrgType()));
                    });
        }
        if (CollectionUtil.isNotEmpty(salesOrgLevelMap)) {
            collect.stream()
                    .filter(k -> StringUtils.isNotBlank(k.getSalesOrgLevel()))
                    .forEach(vo -> {
                        vo.setSalesOrgLevelName(salesOrgLevelMap.get(vo.getSalesOrgLevel()));
                    });
        }
        for (SalesOrgTreeVo orgTreeVo : collect) {
            if (StringUtils.isBlank(orgTreeVo.getParentCode())) {
                tree.add(orgTreeVo);
            }
            List<SalesOrgTreeVo> children = orgTreeVo.getChildren();
            if (children == null) {
                children = new ArrayList<>();
            }
            for (SalesOrgTreeVo orgTreeRespVo : collect) {
                if (Objects.equals(orgTreeVo.getSalesOrgCode(), orgTreeRespVo.getParentCode())) {
                    children.add(orgTreeRespVo);
                }
            }
            orgTreeVo.setChildren(children);
        }
        return tree;
    }

    /**
     * 带条件查询整课树
     *
     * @param orgPaginationDto
     * @return
     */
    @Override
    public List<SalesOrgTreeVo> findAllStruTreeByCondition(SalesOrgPaginationDto orgPaginationDto) {
        return this.findTree(orgPaginationDto);
    }


    /**
     * 查询整课树公共方法
     *
     * @param dto
     * @return
     */
    private List<SalesOrgTreeVo> findTree(SalesOrgPaginationDto dto) {
        /**
         * 1。先查询所有组织
         * 2。找出parentCode为null或者parentCode不存在与数据中 ， 为第一层
         * 3。依次寻找每层的孩子节点
         */
        if (StringUtils.isEmpty(dto.getSalesOrgName())
                && StringUtils.isEmpty(dto.getCodeOrgName())) {
            dto.setSalesOrgLevel(SalesOrgLevelTypeEnum.MECHANISM.getCode());
        }
        List<SalesOrg> list = this.orgService.findByConditions(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List<String> ruleCodes = list.stream().map(SalesOrg::getRuleCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ruleCodes)) {
            list = this.orgService.findAllParentByRuleCodes(ruleCodes);
        }
        List<SalesOrgTreeVo> totalList = (List<SalesOrgTreeVo>) this.nebulaToolkitService.copyCollectionByBlankList(list, SalesOrg.class, SalesOrgTreeVo.class, HashSet.class, ArrayList.class);
        //构建树list
        List<SalesOrgTreeVo> treeList = new ArrayList<>();
        //当前操作层级数据 要查找的层级
        List<SalesOrgTreeVo> currentLevelList = new ArrayList<>();
        //未操作数据
        List<SalesOrgTreeVo> restList = new ArrayList<>();
        //key:id
        Map<String, SalesOrgTreeVo> totalMap = totalList.stream().collect(Collectors.toMap(SalesOrgTreeVo::getSalesOrgCode, v -> v));
        //查找第一层 parentCode为null或者parentCode不存在与数据中 ， 为第一层
        for (SalesOrgTreeVo item : totalList) {
            if (StringUtils.isBlank(item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
                treeList.add(item);
                currentLevelList.add(item);
            } else {
                restList.add(item);
            }
        }
        //构建数据，从第二层开始
        while (currentLevelList.size() > 0 && restList.size() > 0) {
            List<SalesOrgTreeVo> restTempList = new ArrayList<>();
            List<SalesOrgTreeVo> curLevelTempList = new ArrayList<>();
            Set<String> curLevelSet = currentLevelList.stream().map(SalesOrgTreeVo::getSalesOrgCode).collect(Collectors.toSet());
            Map<String, List<SalesOrgTreeVo>> curLevelChildrenMap = new HashMap<>();

            for (SalesOrgTreeVo item : restList) {
                //是否属于当前层
                if (curLevelSet.contains(item.getParentCode())) {
                    curLevelTempList.add(item);
                    List<SalesOrgTreeVo> childrenList = new ArrayList<>();
                    if (curLevelChildrenMap.containsKey(item.getParentCode())) {
                        childrenList.addAll(curLevelChildrenMap.get(item.getParentCode()));
                    }
                    childrenList.add(item);
                    curLevelChildrenMap.put(item.getParentCode(), childrenList);
                } else {
                    restTempList.add(item);
                }
            }
            for (SalesOrgTreeVo item : currentLevelList) {
                if (curLevelChildrenMap.containsKey(item.getSalesOrgCode())) {
                    item.setChildren(curLevelChildrenMap.get(item.getSalesOrgCode()));
                }
            }
            currentLevelList.clear();
            currentLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }

}
