package com.biz.crm.mdm.business.sales.org.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 销售组织事件dto
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.13 19:06
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "销售组织事件dto")
public class SalesOrgEventDto extends TenantDto implements NebulaEventDto {

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;
    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    private String salesOrgName;
    /**
     * 销售组织类型
     */
    @ApiModelProperty("销售组织类型（字典mdm_org_type）")
    private String salesOrgType;

    /**
     * 上级销售组织编码
     */
    @ApiModelProperty("上级销售组织编码")
    private String parentCode;

    /**
     * 改变之前的上级销售组织编码
     */
    @ApiModelProperty("改变之前的上级销售组织编码")
    private String oldParentCode;

    /**
     * 规则code查询用
     */
    @ApiModelProperty("规则code查询用")
    private String ruleCode;


}
