package com.biz.crm.mdm.business.sales.org.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @describe: 销售组织分页查询dto
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.10.28 15:28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "销售组织分页查询dto")
public class SalesOrgPaginationDto extends TenantFlagOpDto {

    private String id;
    /**
     *
     */
    private String tenantCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    /**
     * 编码名称模糊搜索
     */
    @ApiModelProperty("编码名称模糊搜索")
    private String keyword;

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;
    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    private String salesOrgName;

    @ApiModelProperty("销售机构")
    private String salesInstitutionName;

    /**
     * 销售组织类型
     */
    @ApiModelProperty("销售组织类型（字典mdm_sales_org_type）")
    private String salesOrgType;

    /**
     * 销售组织层级
     */
    @ApiModelProperty("销售组织层级")
    private String salesOrgLevel;

    /**
     * 销售组织名称/销售组织编码
     */
    @ApiModelProperty("销售组织名称/销售组织编码")
    private String codeOrgName;

    /**
     * 上级销售组织编码
     */
    @ApiModelProperty("上级销售组织编码")
    private String parentCode;

    /**
     * 规则code查询用
     */
    @ApiModelProperty("对应SAP销售组织编码成本中心编码")
    private String ruleCode;
    /**
     * 启用禁用
     */
    @ApiModelProperty("启用禁用")
    private String enableStatus;
    /**
     * 销售组织类型集合
     */
    @ApiModelProperty("销售组织类型集合")
    private List<String> salesOrgTypeList;
    /**
     * 对应SAP销售组织编码，模糊查询
     */
    @ApiModelProperty("对应SAP销售组织编码，模糊查询")
    private String sapOrgCode;
    /**
     * 对应SAP销售组织编码利润中心编码，模糊查询
     */
    @ApiModelProperty("对应SAP销售组织编码利润中心编码，模糊查询")
    private String sapProfitOrgCode;
    /**
     * 对应SAP销售组织编码成本中心编码，模糊查询
     */
    @ApiModelProperty("对应SAP销售组织编码成本中心编码，模糊查询")
    private String sapCostOrgCode;
    /**
     * 排除当前销售组织（及全部下级销售组织）
     */
    @ApiModelProperty("排除当前销售组织（及全部下级销售组织）")
    private String excludeAllChildrenOrgCode;
    /**
     * 只查询当前销售组织（及全部下级销售组织）
     */
    @ApiModelProperty("只查询当前销售组织（及全部下级销售组织）")
    private String includeAllChildrenOrgCode;
    /**
     * 销售组织编码，查询这个销售组织及全部下级销售组织（不含当前）
     */
    @ApiModelProperty("销售组织编码，查询这个销售组织及全部下级销售组织（不含当前）")
    private String includeAllChildrenOrgCodeExcludeSelf;
    /**
     * 排除当前销售组织（及全部下级销售组织）
     */
    @ApiModelProperty("排除当前销售组织（及全部下级销售组织）")
    private String excludeAllChildrenRuleCode;
    /**
     * 只查询当前销售组织（及全部下级销售组织）
     */
    @ApiModelProperty("只查询当前销售组织（及全部下级销售组织）")
    private String includeAllChildrenRuleCode;

    /**
     * 销售组织编码集合，查询这些销售组织及全部下级销售组织（含当前销售组织）
     */
    @ApiModelProperty("销售组织编码集合，查询这些销售组织及全部下级销售组织（含当前销售组织）")
    private List<String> allChildrenOrgCodesIncludeSelf;
    /**
     * 销售组织编码集合，查询这些销售组织的全部下级销售组织（不含当前，如果参数本身有上下级关系，则要返回处于下级的销售组织）
     */
    @ApiModelProperty("销售组织编码集合，查询这些销售组织的全部下级销售组织（不含当前，如果参数本身有上下级关系，则要返回处于下级的销售组织）")
    private List<String> allChildrenOrgCodesExcludeSelf;
    /**
     * 销售组织编码集合，查询这些销售组织的全部下级销售组织（不含参数中的任意一个销售组织）
     */
    @ApiModelProperty("销售组织编码集合，查询这些销售组织的全部下级销售组织（不含参数中的任意一个销售组织）")
    private List<String> allChildrenOrgCodesExcludeAnySelf;

    /**
     * 销售组织编码集合
     */
    @ApiModelProperty("销售组织编码集合")
    private List<String> salesOrgCodes;
    /**
     * 回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据
     */
    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;
    /**
     * 回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据
     */
    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private List<String> selectedCodes;

    /**
     * 业态
     */
    @ApiModelProperty("业态")
    private String businessFormatCode;

    /**
     * 渠道编码
     */
    @ApiModelProperty("渠道编码")
    private String channelCode;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty("渠道名称")
    private String channelName;

    /**
     * Returns the page to be returned.
     *
     * @return the page to be returned.
     */
    private int pageNumber;

    /**
     * Returns the number of items to be returned.
     *
     * @return the number of items of that page
     */
    private int pageSize;
}
