package com.biz.crm.mdm.business.sales.org.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.util.List;

@Data
@ApiModel(value = "SalesOrgSelectDto", description = "销售组织dto")
public class SalesOrgSelectDto  extends TenantFlagOpDto {

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织层级
     */
    @ApiModelProperty("销售组织层级")
    private String salesOrgLevel;

    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    private String salesOrgName;

    /**
     * 顶层销售组织编码
     */
    @ApiModelProperty("顶层销售组织编码")
    private String topSalesOrgCode;
    /**
     * 规则编码
     */
    @ApiModelProperty("规则编码")
    private String ruleCode;

    /**
     * 用于下拉列表选择,输入回显编码集合，字符串数组，一般用于多选" +
     * "，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据
     */
    @ApiModelProperty("用于下拉列表选择,输入回显编码集合，字符串数组，一般用于多选" +
            "，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private List<String> selectedCodes;

    private String selectedCode;

    /**
     * 编码名称模糊查询
     */
    @ApiModelProperty("编码名称模糊查询")
    private String keyWord;

    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元编码")
    private String businessUnitCode;

    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    @ApiModelProperty(name = "渠道", notes = "")
    private String channelCode;

    @ApiModelProperty(name = "codeOrNameList", notes = "编码/名称")
    private List<String> codeOrNameList;
}
