package com.biz.crm.mdm.business.sales.org.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 销售组织业务类型
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.16 17:10
 */
@Getter
@AllArgsConstructor
public enum SalesOrgBusinessTypeEnum {
    /**
     * 业态
     */
    FORMAT("format", "业态"),
    /**
     * 业务单元
     */
    UNIT("unit", "业务单元"),
    /**
     * 渠道
     */
    CHANNEL("channel", "渠道"),
    ;

    /**
     * 编码
     */
    private String code;
    /**
     * 描述
     */
    private String desc;

    /**
     * 通过key获取
     *
     * @param key
     * @return
     */
    public static SalesOrgBusinessTypeEnum getByCode(String key) {
        return Arrays.stream(SalesOrgBusinessTypeEnum.values()).filter(item -> Objects.equals(item.getCode(), key))
                .findFirst().orElse(null);
    }


    public static Map<String, String> GET_MAP = new HashMap<>();

    static {
        for (SalesOrgBusinessTypeEnum type : SalesOrgBusinessTypeEnum.values()) {
            GET_MAP.put(type.getCode(), type.getDesc());
        }
    }
}
