package com.biz.crm.mdm.business.sales.org.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 销售组织业务类型
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.16 17:10
 */
@Getter
@AllArgsConstructor
public enum SalesOrgLevelTypeEnum {


    MECHANISM("mechanism", 1, "销售机构"),
    DEPARTMENT("department", 2, "销售部门"),

    GROUP("group", 3, "销售组"),
    DEPART_TPM("depart_tpm", 4, "销售部门(TPM)"),
    AREA("area", 5, "销售区域"),
    ;

    /**
     * 编码
     */
    private String code;
    /**
     * 级别
     */
    private Integer level;
    /**
     * 描述
     */
    private String desc;

    /**
     * 通过key获取
     *
     * @param key
     * @return
     */
    public static SalesOrgLevelTypeEnum getByCode(String key) {
        return Arrays.stream(SalesOrgLevelTypeEnum.values())
                .filter(item -> Objects.equals(item.getCode(), key))
                .findFirst().orElse(null);
    }


    public static Map<String, String> GET_MAP = new HashMap<>();

    static {
        for (SalesOrgLevelTypeEnum type : SalesOrgLevelTypeEnum.values()) {
            GET_MAP.put(type.getCode(), type.getDesc());
        }
    }
}
