package com.biz.crm.mdm.business.sales.org.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @Description 组织类型枚举
 * @Author Gavin
 * @Date Created in 2021/5/20 下午3:57
 */
@Getter
@AllArgsConstructor
public enum SalesOrgTypeEnum {
    /**
     * 集团
     */
    GROUP("group", "group", "集团", "1"),
    /**
     * 公司
     */
    COMPANY("company", "company", "公司", "2"),
    /**
     * 事业部
     */
    DIVISION("division", "division", "事业部", "3"),
    /**
     * 大区
     */
    REGION("region", "region", "大区", "4"),
    /**
     * 营业区
     */
    AREA("area", "area", "营业区", "5"),
    /**
     * 部门
     */
    DEPARTMENT("department", "department", "部门", "6"),
    ;


    private String key;
    /**
     * 字典编码
     */
    private String dictCode;
    /**
     * 字典值
     */
    private String value;
    /**
     * 字典排序
     */
    private String order;

    public String getKey() {
        return key;
    }

    public String getDictCode() {
        return dictCode;
    }

    public String getValue() {
        return value;
    }

    public String getOrder() {
        return order;
    }

    /**
     * 通过key获取
     *
     * @param key
     * @return
     */
    public static SalesOrgTypeEnum getByKey(String key) {
        return Arrays.stream(SalesOrgTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
                .findFirst().orElse(null);
    }


    public static Map<String, String> GET_MAP = new HashMap<>();

    static {
        for (SalesOrgTypeEnum type : SalesOrgTypeEnum.values()) {
            GET_MAP.put(type.getDictCode(), type.getValue());
        }
    }
}
