package com.biz.crm.mdm.business.sales.org.sdk.event;

import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgEventBatchDto;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

import java.util.List;

/**
 * 销售组织事件监听器
 *
 * @author hecheng
 * @date 2021/09/29
 */
public interface SalesOrgEventListener extends NebulaEvent {

    /**
     * 当删除一批销售组织时触发删除事件
     *
     * @param orgCodes
     */
    void onDelete(List<String> orgCodes);

    /**
     * 当删除一批销售组织时触发删除事件
     *
     * @param orgEventBatchDto
     */
    void onDeleteBatch(SalesOrgEventBatchDto orgEventBatchDto);

    /**
     * 当启用一批销售组织时触发批量启用事件
     *
     * @param orgEventBatchDto
     */
    void onEnableBatch(SalesOrgEventBatchDto orgEventBatchDto);

    /**
     * 当禁用一批销售组织时触发批量禁用事件
     *
     * @param orgEventBatchDto
     */
    void onDisableBatch(SalesOrgEventBatchDto orgEventBatchDto);

    /**
     * 当修改销售组织时触发删除事件
     *
     * @param orgEventDto
     */
    void onUpdate(SalesOrgEventDto orgEventDto);
}
