package com.biz.crm.mdm.business.sales.org.sdk.service;


import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;

import java.util.List;

/**
 * 销售组织缓存 service
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.13 19:25
 */
public interface SalesOrgCacheService {

    /**
     * 按销售组织orgCodes 刷新缓存
     *
     * @param orgCodes
     */
    void refreshByOrgCodes(List<String> orgCodes);

    /**
     * 刷新缓存
     */
    void refreshAll();

    /**
     * 清空缓存
     */
    void removeAll();

    /**
     * 根据销售组织编码获取销售组织详情,如果缓存中不存在，那么从数据库中获取并缓存。
     *
     * @param orgCode 销售组织编码
     * @return
     */
    SalesOrgVo findByOrgCode(String orgCode);

    /**
     * 根据销售组织编码获取销售组织的子节点
     *
     * @param orgCode
     * @return
     */
    List<SalesOrgVo> findChildrenByOrgCode(String orgCode);

    /**
     * 根据销售组织编码获取该销售组织所在销售组织树的根节点
     *
     * @param orgCode 销售组织编码
     * @return
     */
    SalesOrgVo findTopParentByOrgCode(String orgCode);

    /**
     * 根据销售组织编码获取销售组织及销售组织全部上级
     *
     * @param orgCode 销售组织编码
     * @return
     */
    List<SalesOrgVo> findAllParentIncludeSelf(String orgCode);

    /**
     * 根据销售组织编码集合获取销售组织及销售组织全部上级
     *
     * @param orgCodes 销售组织编码集合
     * @return
     */
    List<SalesOrgVo> findAllParentIncludeSelf(List<String> orgCodes);

    /**
     * 根据销售组织编码获取销售组织（不含自己）全部上级
     *
     * @param orgCode 销售组织编码
     * @return
     */
    List<SalesOrgVo> findAllParentExcludeSelf(String orgCode);

    /**
     * 根据销售组织编码集合获取销售组织详情
     *
     * @param orgCodes 销售组织编码集合
     * @return
     */
    List<SalesOrgVo> findByOrgCodes(List<String> orgCodes);

    /**
     * 根据销售组织编码获取销售组织及销售组织全部下级
     *
     * @param orgCode 销售组织编码
     * @return
     */
    List<SalesOrgVo> findAllChildrenIncludeSelf(String orgCode);

    /**
     * 根据销售组织编码集合获取销售组织及销售组织全部下级
     *
     * @param orgCodes 销售组织编码集合
     * @return
     */
    List<SalesOrgVo> findAllChildrenIncludeSelf(List<String> orgCodes);

    /**
     * 根据销售组织编码获取销售组织（不含自己）全部下级
     *
     * @param orgCode 销售组织编码
     * @return
     */
    List<SalesOrgVo> findAllChildrenExcludeSelf(String orgCode);

    /**
     * 根据销售组织编码获取销售组织（不含自己）全部下级
     *
     * @param orgCodes 销售组织编码
     * @return
     */
    List<SalesOrgVo> findAllChildrenExcludeSelf(List<String> orgCodes);

    /**
     * 根据销售组织编码获取销售组织及销售组织全部上级（只查启用）
     *
     * @param orgCode 销售组织编码
     * @return
     */
    List<SalesOrgVo> findAllEnableParentIncludeSelf(String orgCode);

    /**
     * 根据销售组织编码集合获取销售组织及销售组织全部上级（只查启用）
     *
     * @param orgCodes 销售组织编码集合
     * @return
     */
    List<SalesOrgVo> findAllEnableParentIncludeSelf(List<String> orgCodes);

    /**
     * 根据销售组织编码获取销售组织及销售组织全部下级（只查启用）
     *
     * @param orgCode 销售组织编码
     * @return
     */
    List<SalesOrgVo> findAllEnableChildrenIncludeSelf(String orgCode);

    /**
     * 根据销售组织编码集合获取销售组织及销售组织全部下级（只查启用）
     *
     * @param orgCodes 销售组织编码集合
     * @return
     */
    List<SalesOrgVo> findAllEnableChildrenIncludeSelf(List<String> orgCodes);

    /**
     * 根据销售组织编码获取销售组织（不含自己）全部下级（只查启用）
     *
     * @param orgCode 销售组织编码
     * @return
     */
    List<SalesOrgVo> findAllEnableChildrenExcludeSelf(String orgCode);

    /**
     * 根据销售组织编码获取销售组织及销售组织全部上级销售组织编码
     *
     * @param orgCode 销售组织编码
     * @return
     */
    List<String> findAllParentOrgCodeIncludeSelf(String orgCode);

    /**
     * 根据销售组织编码集合获取销售组织及销售组织全部上级销售组织编码
     *
     * @param orgCodes 销售组织编码集合
     * @return
     */
    List<String> findAllParentOrgCodeIncludeSelf(List<String> orgCodes);

    /**
     * 根据销售组织编码获取销售组织（不含自己）全部上级销售组织编码
     *
     * @param orgCode 销售组织编码
     * @return
     */
    List<String> findAllParentOrgCodeExcludeSelf(String orgCode);

    /**
     * 根据销售组织编码获取销售组织（不含自己）全部上级销售组织编码
     *
     * @param orgCodes 销售组织编码
     * @return
     */
    List<String> findAllParentOrgCodeExcludeSelf(List<String> orgCodes);

    /**
     * 根据销售组织编码集合获取销售组织（不含参数中任何一个）全部下级
     *
     * @param orgCodes 销售组织编码集合
     * @return
     */
    List<SalesOrgVo> findAllChildrenExcludeAnySelf(List<String> orgCodes);

    /**
     * 根据销售组织编码集合获取销售组织（不含参数中任何一个）全部下级销售组织编码
     *
     * @param orgCodes 销售组织编码集合
     * @return
     */
    List<String> findAllChildrenOrgCodeExcludeAnySelf(List<String> orgCodes);

    /**
     * 根据销售组织编码获取销售组织及销售组织全部上级销售组织编码（只查启用）
     *
     * @param orgCode 销售组织编码
     * @return
     */
    List<String> findAllEnableParentOrgCodeIncludeSelf(String orgCode);

    /**
     * 根据销售组织编码集合获取销售组织及销售组织全部上级销售组织编码（只查启用）
     *
     * @param orgCodes 销售组织编码集合
     * @return
     */
    List<String> findAllEnableParentOrgCodeIncludeSelf(List<String> orgCodes);

    /**
     * 根据销售组织编码获取销售组织（不含自己）全部上级（只查启用）
     *
     * @param orgCode 销售组织编码
     * @return
     */
    List<SalesOrgVo> findAllEnableParentExcludeSelf(String orgCode);

    /**
     * 根据销售组织编码获取销售组织（不含自己）全部上级销售组织编码（只查启用）
     *
     * @param orgCode 销售组织编码
     * @return
     */
    List<String> findAllEnableParentOrgCodeExcludeSelf(String orgCode);

    /**
     * 根据销售组织编码获取销售组织及销售组织全部下级销售组织编码（只查启用）
     *
     * @param orgCode 销售组织编码
     * @return
     */
    List<String> findAllEnableChildrenOrgCodeIncludeSelf(String orgCode);

    /**
     * 根据销售组织编码集合获取销售组织及销售组织全部下级销售组织编码（只查启用）
     *
     * @param orgCodes 销售组织编码集合
     * @return
     */
    List<String> findAllEnableChildrenOrgCodeIncludeSelf(List<String> orgCodes);

    /**
     * 根据销售组织编码获取销售组织（不含自己）全部下级销售组织编码（只查启用）
     *
     * @param orgCode 销售组织编码
     * @return
     */
    List<String> findAllEnableChildrenOrgCodeExcludeSelf(String orgCode);
}
