package com.biz.crm.mdm.business.sales.org.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgSubComOrgDto;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 销售组织与分子公司组织对应关系
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.13 19:30
 */
public interface SalesOrgSubComOrgService {

    /**
     * 分页批量查询
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo>
     * @author huojia
     * @date 2022/11/21 18:35
     **/
    Page<SalesOrgSubComOrgVo> findByConditions(Pageable pageable, SalesOrgSubComOrgDto dto);

    /**
     * 批量新增（外部接口新增）
     *
     * @param salesOrgSubComOrgDtoList
     * @author huojia
     * @date 2022/11/21 18:42
     **/
    void saveBatch(List<SalesOrgSubComOrgDto> salesOrgSubComOrgDtoList);

    /**
     * 根据分子公司组织编码（客户编码）查询对应关系
     *
     * @param subComOrgCodeList
     * @return java.util.List<com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo>
     * @author huojia
     * @date 2022/11/22 14:25
     **/
    List<SalesOrgSubComOrgVo> listBySubComOrgCodeList(List<String> subComOrgCodeList);

    List<SalesOrgSubComOrgVo> findBySaleOrgErpCode(String salesOrgErpCode);

    List<SalesOrgSubComOrgVo> findAll();

    /**
     * 设置增值税税率
     * @param dto
     */
    void setVatRate(SalesOrgSubComOrgDto dto);
}
