package com.biz.crm.mdm.business.sales.org.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.sales.org.sdk.dto.RelateSalesOrgCodeQueryDto;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgPaginationDto;
import com.biz.crm.mdm.business.sales.org.sdk.dto.SalesOrgQueryDto;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 销售组织vo service
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.13 19:30
 */
public interface SalesOrgVoService {

    /**
     * 分页条件查询
     *
     * @param pageable
     * @param paginationDto
     * @return
     */
    Page<SalesOrgVo> findByConditions(Pageable pageable, SalesOrgPaginationDto paginationDto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    SalesOrgVo findDetailsById(String id);

    /**
     * 按销售组织code查询详情
     *
     * @param orgCode
     * @return
     */
    SalesOrgVo findBySalesOrgCode(String orgCode);

    /**
     * 按id集合查询
     *
     * @param ids
     * @return
     */
    List<SalesOrgVo> findDetailsByIds(List<String> ids);

    /**
     * 按orgCode集合查询
     *
     * @param orgCodes
     * @return
     */
    List<SalesOrgVo> findBySalesOrgCodes(List<String> orgCodes);

    /**
     * 按orgCode集合查询
     *
     * @param orgCodes
     * @return
     */
    List<SalesOrgVo> findBySalesOrgCodesPost(List<String> orgCodes);

    /**
     * 查询指定id下的所有子节点
     *
     * @param id
     * @return
     */
    List<SalesOrgVo> findAllChildrenById(String id);

    /**
     * 查询指定orgCode下的所有子节点
     *
     * @param orgCode
     * @return
     */
    List<SalesOrgVo> findAllChildrenBySalesOrgCode(String orgCode);

    /**
     * 查询orgCodes下的所有子节点
     *
     * @param orgCodes
     * @return
     */
    List<SalesOrgVo> findAllChildrenBySalesOrgCodes(List<String> orgCodes);


    /**
     * 根据 销售组织编码查询 全部上级（含当前）销售组织列表
     *
     * @param orgCode
     * @return
     */
    List<SalesOrgVo> findAllParentBySalesOrgCode(String orgCode);

    /**
     * 根据 销售组织编码集合查询 全部上级（含当前）销售组织列表
     *
     * @param orgCodes
     * @return
     */
    List<SalesOrgVo> findAllParentBySalesOrgCodes(List<String> orgCodes);

    /**
     * 获取销售组织编码集合
     *
     * @param dto
     * @return
     */
    default Set<String> findBySalesOrgQueryDto(SalesOrgQueryDto dto) {
        return Sets.newHashSet();
    }

    /**
     * 根据获取销售组织对应的未删除的（同级|上级|下级，searchType = 0 同级 > 0 上级 < 0 下级，都包含自己 ）编码
     *
     * @param dto
     * @return k-orgCode,v-ruleCode
     */
    default Map<String, String> findByRelateSalesOrgCodeQueryDto(RelateSalesOrgCodeQueryDto dto) {
        return Maps.newHashMap();
    }


    /**
     * 查询指定salesOrgLevel 下的所有销售组织编码和名称(MDG)
     *
     * @param salesOrgLevel
     * @param salesOrgName
     * @return
     **/
    List<SalesOrgVo> findAllSalesOrgLevelBySalesOrg(String salesOrgLevel,String salesOrgName);


    /**
     * 根据所属销售机构编码查询所属销售机构名称和所属销售机构部门名称和销售组名称
     * @param salesAgencyCode
     * @return
     */
    List<String> findBySalesOrgName(String salesAgencyCode);

    /**
     * 根据销售组织erp编码获取全部销售组织
     * @param salesOrgErpCodeList
     * @return
     */
    List<SalesOrgVo> findByErpCodeList(List<String> salesOrgErpCodeList);

    /**
     * 根据销售编码查询销售组名称
     * @param source2Code
     * @return
     */
    List<String> findByMdgSalesOrgCode(String source2Code);



    /**
     * 根据erp编码查询销售组织全部信息
     *
     * @param erpCodes erp编码列表
     * @return Map<String, SalesOrgVo>
     */
    Map<String, SalesOrgVo> getSalesMapByErpCodes(List<List<String>> erpCodes);

    /**
     * 根据tpm销售组织编码查询销售组织全部信息
     *
     * @param tpmCodes tpm销售组织编码列表
     * @return Map<String, SalesOrgVo>
     */
    Map<String, SalesOrgVo> getSalesMapByTpmCodes(List<String> tpmCodes);

    /**
     * 根据销售组织编码集合查询对应sap编码
     *
     * @param salesOrgCodes 销售组织编码
     * @return Map<String, String>
     */
    Map<String, String> findSapCodesBySalesOrgCodes(List<String> salesOrgCodes);

    /**
     * 根据销售组织编码集合查询对应名称
     *
     * @param salesOrgCodes 销售组织编码
     * @return Map<String, String>
     */
    Map<String, String> findNameBySalesOrgCodes(List<List<String>> salesOrgCodes);

    /**
     * erp编码查询名称
     * @param erpCodes
     * @return {@link Map}<{@link String}, {@link String}>
     */
    default Map<String, String> findNameByErpCodes(List<String> erpCodes){
        return Maps.newHashMap();
    }

    /**
     * 根据编码或者名称查询
     * @param codeOrName
     * @return {@link List}<{@link SalesOrgVo}>
     */
    default List<SalesOrgVo> findByCodeOrName(List<String> codeOrName){
        return Lists.newArrayList();
    }

    /**
     * 业务单元编辑时，同步更新销售组织上的业务单元
     *
     * @param businessUnitCode 业务单元
     * @param salesOrgCodes    销售组织编码
     */
    void editSalesOrgBusinessUnit(String businessUnitCode, List<String> salesOrgCodes);
}
