package com.biz.crm.mdm.business.sales.org.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * 销售组织与分子公司组织对应关系
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.10.28 14:43
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "销售组织与分子公司组织对应关系")
public class SalesOrgSubComOrgVo extends TenantFlagOpVo {

    /**
     * 分子公司组织编码
     */
    @ApiModelProperty("分子公司组织编码")
    private String subComOrgCode;

    /**
     * 分子公司组织名称
     */
    @ApiModelProperty("分子公司组织名称")
    private String subComOrgName;

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    private String salesOrgName;

    @ApiModelProperty("增值税税率")
    private BigDecimal vatRate;
}
